/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.campaign;

import com.chutneytesting.design.domain.campaign.Campaign;
import com.chutneytesting.design.domain.campaign.CampaignExecutionReport;
import com.chutneytesting.design.domain.campaign.CampaignNotFoundException;
import com.chutneytesting.design.domain.campaign.CampaignRepository;
import com.chutneytesting.design.domain.campaign.ScenarioExecutionReportCampaign;
import com.chutneytesting.design.domain.dataset.DataSetHistoryRepository;
import com.chutneytesting.design.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.design.domain.scenario.ScenarioNotParsableException;
import com.chutneytesting.design.domain.scenario.TestCase;
import com.chutneytesting.design.domain.scenario.TestCaseRepository;
import com.chutneytesting.execution.domain.ExecutionRequest;
import com.chutneytesting.execution.domain.campaign.CampaignAlreadyRunningException;
import com.chutneytesting.execution.domain.campaign.CampaignExecutionNotFoundException;
import com.chutneytesting.execution.domain.history.ExecutionHistory;
import com.chutneytesting.execution.domain.history.ExecutionHistoryRepository;
import com.chutneytesting.execution.domain.jira.JiraXrayPlugin;
import com.chutneytesting.execution.domain.report.ScenarioExecutionReport;
import com.chutneytesting.execution.domain.report.ServerReportStatus;
import com.chutneytesting.execution.domain.scenario.FailedExecutionAttempt;
import com.chutneytesting.execution.domain.scenario.ScenarioExecutionEngine;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedTestCase;
import com.chutneytesting.instrument.domain.ChutneyMetrics;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampaignExecutionEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(Campaign.class);
    private ExecutorService executor;
    private final CampaignRepository campaignRepository;
    private final ScenarioExecutionEngine scenarioExecutionEngine;
    private final ExecutionHistoryRepository executionHistoryRepository;
    private final TestCaseRepository testCaseRepository;
    private final DataSetHistoryRepository dataSetHistoryRepository;
    private final JiraXrayPlugin jiraXrayPlugin;
    private final ChutneyMetrics metrics;
    private Map<Long, CampaignExecutionReport> currentCampaignExecutions = new ConcurrentHashMap<Long, CampaignExecutionReport>();
    private Map<Long, Boolean> currentCampaignExecutionsStopRequests = new ConcurrentHashMap<Long, Boolean>();

    public CampaignExecutionEngine(CampaignRepository campaignRepository, ScenarioExecutionEngine scenarioExecutionEngine, ExecutionHistoryRepository executionHistoryRepository, TestCaseRepository testCaseRepository, DataSetHistoryRepository dataSetHistoryRepository, JiraXrayPlugin jiraXrayPlugin, ChutneyMetrics metrics, Integer threadForCampaigns) {
        this.campaignRepository = campaignRepository;
        this.scenarioExecutionEngine = scenarioExecutionEngine;
        this.executionHistoryRepository = executionHistoryRepository;
        this.testCaseRepository = testCaseRepository;
        this.dataSetHistoryRepository = dataSetHistoryRepository;
        this.jiraXrayPlugin = jiraXrayPlugin;
        this.metrics = metrics;
        this.executor = Executors.newFixedThreadPool(threadForCampaigns);
        LOGGER.debug("Pool for campaigns created with size {}", (Object)threadForCampaigns);
    }

    public List<CampaignExecutionReport> executeByName(String campaignName, String userId) {
        return this.executeByName(campaignName, null, userId);
    }

    public List<CampaignExecutionReport> executeByName(String campaignName, String environment, String userId) {
        List<Campaign> campaigns = this.campaignRepository.findByName(campaignName);
        return campaigns.stream().map(campaign -> this.selectExecutionEnvironment((Campaign)campaign, Optional.ofNullable(environment))).map(campaign -> this.executeCampaign((Campaign)campaign, userId)).collect(Collectors.toList());
    }

    public CampaignExecutionReport executeById(Long campaignId, String userId) {
        return this.executeById(campaignId, null, userId);
    }

    public CampaignExecutionReport executeById(Long campaignId, String environment, String userId) {
        return Optional.ofNullable(this.campaignRepository.findById(campaignId)).map(campaign -> this.selectExecutionEnvironment((Campaign)campaign, Optional.ofNullable(environment))).map(campaign -> this.executeCampaign((Campaign)campaign, userId)).orElseThrow(() -> new CampaignNotFoundException(campaignId));
    }

    public Optional<CampaignExecutionReport> currentExecution(Long campaignId) {
        return this.currentCampaignExecutions.entrySet().stream().filter(e -> ((Long)e.getKey()).equals(campaignId)).map(Map.Entry::getValue).findFirst();
    }

    public List<CampaignExecutionReport> currentExecutions() {
        return new ArrayList<CampaignExecutionReport>(this.currentCampaignExecutions.values());
    }

    public void stopExecution(Long executionId) {
        LOGGER.trace("Stop requested for " + executionId);
        Optional.ofNullable(this.currentCampaignExecutionsStopRequests.computeIfPresent(executionId, (aLong, aBoolean) -> Boolean.TRUE)).orElseThrow(() -> new CampaignExecutionNotFoundException(executionId));
    }

    public CampaignExecutionReport executeScenarioInCampaign(List<String> failedIds, Campaign campaign, String userId) {
        CampaignExecutionReport campaignExecutionReport;
        CampaignExecutionReport campaignExecutionReport2;
        Long executionId;
        block5: {
            this.verifyNotAlreadyRunning(campaign);
            executionId = this.campaignRepository.newCampaignExecution();
            Optional<Pair<String, Integer>> executionDataSet = this.findExecutionDataSet(campaign);
            campaignExecutionReport2 = new CampaignExecutionReport(executionId, campaign.title, !failedIds.isEmpty(), campaign.executionEnvironment(), executionDataSet.map(Pair::getLeft).orElse(null), executionDataSet.map(Pair::getRight).orElse(null), userId);
            this.currentCampaignExecutions.put(campaign.id, campaignExecutionReport2);
            this.currentCampaignExecutionsStopRequests.put(executionId, Boolean.FALSE);
            if (!failedIds.isEmpty()) break block5;
            CampaignExecutionReport campaignExecutionReport3 = this.execute(campaign, campaignExecutionReport2, campaign.scenarioIds);
            campaignExecutionReport2.endCampaignExecution();
            LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecutionReport2.executionId, campaignExecutionReport2.status()});
            this.campaignRepository.saveReport(campaign.id, campaignExecutionReport2);
            this.metrics.onCampaignExecutionEnded(campaign, campaignExecutionReport2);
            this.currentCampaignExecutionsStopRequests.remove(executionId);
            this.currentCampaignExecutions.remove(campaign.id);
            return campaignExecutionReport3;
        }
        try {
            campaignExecutionReport = this.execute(campaign, campaignExecutionReport2, failedIds);
            campaignExecutionReport2.endCampaignExecution();
        }
        catch (Exception e) {
            try {
                LOGGER.error("Not managed exception occured", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                campaignExecutionReport2.endCampaignExecution();
                LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecutionReport2.executionId, campaignExecutionReport2.status()});
                this.campaignRepository.saveReport(campaign.id, campaignExecutionReport2);
                this.metrics.onCampaignExecutionEnded(campaign, campaignExecutionReport2);
                this.currentCampaignExecutionsStopRequests.remove(executionId);
                this.currentCampaignExecutions.remove(campaign.id);
                throw throwable;
            }
        }
        LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecutionReport2.executionId, campaignExecutionReport2.status()});
        this.campaignRepository.saveReport(campaign.id, campaignExecutionReport2);
        this.metrics.onCampaignExecutionEnded(campaign, campaignExecutionReport2);
        this.currentCampaignExecutionsStopRequests.remove(executionId);
        this.currentCampaignExecutions.remove(campaign.id);
        return campaignExecutionReport;
    }

    private CampaignExecutionReport execute(Campaign campaign, CampaignExecutionReport campaignExecutionReport, List<String> scenariosToExecute) {
        LOGGER.trace("Execute campaign {} : {}", (Object)campaign.id, (Object)campaign.title);
        List<TestCase> testCases = scenariosToExecute.stream().map(this.testCaseRepository::findById).filter(Objects::nonNull).collect(Collectors.toList());
        campaignExecutionReport.initExecution(testCases, campaign.executionEnvironment(), campaignExecutionReport.userId);
        try {
            if (campaign.parallelRun) {
                ArrayList toExecute = Lists.newArrayList();
                for (TestCase t : testCases) {
                    toExecute.add(Executors.callable(() -> this.executeScenarioInCampaign(campaign, campaignExecutionReport).accept(t)));
                }
                this.executor.invokeAll(toExecute);
            } else {
                for (TestCase t : testCases) {
                    this.executor.invokeAll(Collections.singleton(Executors.callable(() -> this.executeScenarioInCampaign(campaign, campaignExecutionReport).accept(t))));
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Error ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error ", (Throwable)e);
        }
        return campaignExecutionReport;
    }

    private Consumer<TestCase> executeScenarioInCampaign(Campaign campaign, CampaignExecutionReport campaignExecutionReport) {
        return testCase -> {
            if (!this.currentCampaignExecutionsStopRequests.get(campaignExecutionReport.executionId).booleanValue()) {
                campaignExecutionReport.startScenarioExecution((TestCase)testCase, campaign.executionEnvironment(), campaignExecutionReport.userId);
                ScenarioExecutionReportCampaign scenarioExecutionReport = this.executeScenario(campaign, (TestCase)testCase, campaignExecutionReport.userId);
                if (campaign.retryAuto && ServerReportStatus.FAILURE.equals((Object)scenarioExecutionReport.status())) {
                    scenarioExecutionReport = this.executeScenario(campaign, (TestCase)testCase, campaignExecutionReport.userId);
                }
                Optional.ofNullable(scenarioExecutionReport).ifPresent(serc -> {
                    campaignExecutionReport.endScenarioExecution((ScenarioExecutionReportCampaign)serc);
                    ExecutionHistory.Execution execution = this.executionHistoryRepository.getExecution(serc.scenarioId, serc.execution.executionId());
                    this.jiraXrayPlugin.updateTestExecution(campaign.id, serc.scenarioId, execution.report());
                });
            }
        };
    }

    private ScenarioExecutionReportCampaign executeScenario(Campaign campaign, TestCase testCase, String userId) {
        String scenarioName;
        Long executionId;
        try {
            LOGGER.trace("Execute scenario {} for campaign {}", (Object)testCase.id(), (Object)campaign.id);
            ExecutionRequest executionRequest = this.buildExecutionRequest(campaign, testCase, userId);
            ScenarioExecutionReport scenarioExecutionReport = this.scenarioExecutionEngine.execute(executionRequest);
            executionId = scenarioExecutionReport.executionId;
            scenarioName = scenarioExecutionReport.scenarioName;
        }
        catch (FailedExecutionAttempt e) {
            LOGGER.warn("Failed execution attempt for scenario {} for campaign {}", (Object)testCase.id(), (Object)campaign.id);
            executionId = e.executionId;
            scenarioName = e.title;
        }
        catch (ScenarioNotFoundException | ScenarioNotParsableException se) {
            LOGGER.error("Scenario error for scenario {} for campaign {}", new Object[]{testCase.id(), campaign.id, se});
            return null;
        }
        ExecutionHistory.Execution execution = this.executionHistoryRepository.getExecution(testCase.id(), executionId);
        return new ScenarioExecutionReportCampaign(testCase.id(), scenarioName, execution.summary());
    }

    private ExecutionRequest buildExecutionRequest(Campaign campaign, TestCase testCase, String userId) {
        String campaignDatasetId = campaign.datasetId;
        if (StringUtils.isNotBlank((CharSequence)campaignDatasetId) && testCase instanceof ExecutableComposedTestCase) {
            testCase = ((ExecutableComposedTestCase)testCase).withDataSetId(campaignDatasetId);
            return new ExecutionRequest(testCase, campaign.executionEnvironment(), true, userId);
        }
        HashMap<String, String> ds = new HashMap<String, String>(testCase.computedParameters());
        ds.putAll(campaign.dataSet);
        return new ExecutionRequest(testCase.withDataSet(ds), campaign.executionEnvironment(), userId);
    }

    private Optional<Pair<String, Integer>> findExecutionDataSet(Campaign campaign) {
        String datasetId = campaign.datasetId;
        if (StringUtils.isNotBlank((CharSequence)datasetId)) {
            return Optional.of(Pair.of((Object)datasetId, (Object)this.dataSetHistoryRepository.lastVersion(datasetId)));
        }
        return Optional.empty();
    }

    private CampaignExecutionReport executeCampaign(Campaign campaign, String userId) {
        return this.executeScenarioInCampaign(Collections.emptyList(), campaign, userId);
    }

    private void verifyNotAlreadyRunning(Campaign campaign) {
        Optional<CampaignExecutionReport> currentReport = Optional.ofNullable(this.currentExecutionReport(campaign.id));
        if (currentReport.isPresent() && !currentReport.get().status().isFinal()) {
            throw new CampaignAlreadyRunningException(currentReport.get());
        }
    }

    private Campaign selectExecutionEnvironment(Campaign campaign, Optional<String> environment) {
        environment.ifPresent(campaign::executionEnvironment);
        return campaign;
    }

    private CampaignExecutionReport currentExecutionReport(Long campaignId) {
        return this.currentCampaignExecutions.get(campaignId);
    }
}

