/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.api;

import com.chutneytesting.design.domain.scenario.TestCase;
import com.chutneytesting.design.domain.scenario.TestCaseRepository;
import com.chutneytesting.execution.api.IdeaRequest;
import com.chutneytesting.execution.domain.ExecutionRequest;
import com.chutneytesting.execution.domain.report.ScenarioExecutionReport;
import com.chutneytesting.execution.domain.scenario.ScenarioExecutionEngine;
import com.chutneytesting.execution.domain.scenario.ScenarioExecutionEngineAsync;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedStep;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableStepRepository;
import com.chutneytesting.security.domain.UserService;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import com.chutneytesting.tools.ui.KeyValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Observable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@CrossOrigin(origins={"*"})
@RestController
public class ScenarioExecutionUiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioExecutionUiController.class);
    private final ScenarioExecutionEngine executionEngine;
    private final ScenarioExecutionEngineAsync executionEngineAsync;
    private final TestCaseRepository testCaseRepository;
    private final ObjectMapper objectMapper;
    private final ExecutableStepRepository stepRepository;
    private final UserService userService;

    ScenarioExecutionUiController(ScenarioExecutionEngine executionEngine, ScenarioExecutionEngineAsync executionEngineAsync, TestCaseRepository testCaseRepository, ObjectMapper objectMapper, ExecutableStepRepository stepRepository, UserService userService) {
        this.executionEngine = executionEngine;
        this.executionEngineAsync = executionEngineAsync;
        this.testCaseRepository = testCaseRepository;
        this.objectMapper = objectMapper;
        this.stepRepository = stepRepository;
        this.userService = userService;
    }

    @PostMapping(path={"/api/ui/scenario/execution/v1/{scenarioId}/{env}"})
    public String executeScenario(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="env") String env) throws IOException {
        LOGGER.debug("executeScenario for scenarioId='{}'", (Object)scenarioId);
        TestCase testCase = this.testCaseRepository.findById(scenarioId);
        String userId = this.userService.getCurrentUser().getId();
        ScenarioExecutionReport report = this.executionEngine.execute(new ExecutionRequest(testCase, env, userId));
        return this.objectMapper.writeValueAsString((Object)report);
    }

    @PostMapping(path={"/api/ui/component/execution/v1/{componentId}/{env}"})
    public String executeComponent(@PathVariable(value="componentId") String componentId, @PathVariable(value="env") String env) throws IOException {
        LOGGER.debug("executeComponent for componentId={{}] on env [{}]", (Object)componentId, (Object)env);
        ExecutableComposedStep composedStep = this.stepRepository.findExecutableById(ComposableIdUtils.fromFrontId(Optional.of(componentId)));
        String userId = this.userService.getCurrentUser().getId();
        ScenarioExecutionReport report = this.executionEngine.execute(composedStep, env, userId);
        return this.objectMapper.writeValueAsString((Object)report);
    }

    @PostMapping(path={"/api/idea/scenario/execution/{env}"})
    public String executeScenarioWitRawContent(@RequestBody IdeaRequest ideaRequest, @PathVariable(value="env") String env) throws IOException {
        LOGGER.debug("execute Scenario v2 for content='{}' with parameters '{}'", (Object)ideaRequest.getContent(), ideaRequest.getParams());
        String userId = this.userService.getCurrentUser().getId();
        ScenarioExecutionReport report = this.executionEngine.execute(ideaRequest.getContent(), ideaRequest.getParams(), env, userId);
        return this.objectMapper.writeValueAsString((Object)report);
    }

    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/{env}"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public String executeScenarioAsyncWithDataSet(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="env") String env, @RequestBody List<KeyValue> dataSet) {
        LOGGER.debug("executeScenarioAsync for scenarioId='{}' with dataset '{}'", (Object)scenarioId, dataSet);
        TestCase testCase = this.testCaseRepository.findById(ComposableIdUtils.fromFrontId(Optional.of(scenarioId)));
        Map inlineDataSet = Optional.ofNullable(dataSet).map(KeyValue::toMap).orElseGet(HashMap::new);
        String userId = this.userService.getCurrentUser().getId();
        return this.executionEngineAsync.execute(new ExecutionRequest(testCase, env, inlineDataSet, userId)).toString();
    }

    @GetMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}"})
    public Flux<ServerSentEvent<ScenarioExecutionReport>> followScenarioExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("followScenarioExecution for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        return this.createScenarioExecutionSSEFlux(this.executionEngineAsync.followExecution(scenarioId, executionId));
    }

    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}/stop"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void stopExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Stop for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        this.executionEngineAsync.stop(scenarioId, executionId);
    }

    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}/pause"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void pauseExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Pause for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        this.executionEngineAsync.pause(scenarioId, executionId);
    }

    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}/resume"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resumeExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Resume for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        this.executionEngineAsync.resume(scenarioId, executionId);
    }

    private Flux<ServerSentEvent<ScenarioExecutionReport>> createScenarioExecutionSSEFlux(Observable<ScenarioExecutionReport> scenarioExecutionReports) {
        return Flux.from((Publisher)scenarioExecutionReports.map(reportEvent -> ServerSentEvent.builder().id(String.valueOf(reportEvent.executionId)).event(reportEvent.report.isTerminated() ? "last" : "partial").data(reportEvent).build()).toFlowable(BackpressureStrategy.BUFFER));
    }
}

