/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.api;

import com.chutneytesting.execution.api.ExecutionSummaryDto;
import com.chutneytesting.execution.domain.history.ExecutionHistory;
import com.chutneytesting.execution.domain.history.ExecutionHistoryRepository;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
class ScenarioExecutionHistoryController {
    private final ExecutionHistoryRepository executionHistoryRepository;

    ScenarioExecutionHistoryController(ExecutionHistoryRepository executionHistoryRepository) {
        this.executionHistoryRepository = executionHistoryRepository;
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(path={"/api/ui/scenario/{scenarioId}/execution/v1"}, produces={"application/json;charset=UTF-8"})
    public List<ExecutionSummaryDto> listExecutions(@PathVariable(value="scenarioId") String scenarioId) {
        return ExecutionSummaryDto.toDto(this.executionHistoryRepository.getExecutions(ComposableIdUtils.fromFrontId(Optional.of(scenarioId))));
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(path={"/api/ui/scenario/{scenarioId}/execution/{executionId}/v1"}, produces={"application/json;charset=UTF-8"})
    public ExecutionHistory.Execution getExecutionReport(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        return this.executionHistoryRepository.getExecution(ComposableIdUtils.fromFrontId(Optional.of(scenarioId)), executionId);
    }
}

