/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.api;

import com.chutneytesting.execution.api.ImmutableExecutionSummaryDto;
import com.chutneytesting.execution.domain.history.ExecutionHistory;
import com.chutneytesting.execution.domain.history.ImmutableExecutionHistory;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableExecutionSummaryDto.class)
@JsonDeserialize(as=ImmutableExecutionSummaryDto.class)
@Value.Immutable
public interface ExecutionSummaryDto
extends ExecutionHistory.ExecutionProperties,
ExecutionHistory.Attached {
    public static List<ExecutionSummaryDto> toDto(Collection<ExecutionHistory.ExecutionSummary> executionSummaryList) {
        return executionSummaryList.stream().map(ExecutionSummaryDto::toDto).collect(Collectors.toList());
    }

    public static ExecutionSummaryDto toDto(ExecutionHistory.ExecutionSummary executionSummary) {
        return ImmutableExecutionSummaryDto.builder().time(executionSummary.time()).duration(executionSummary.duration()).status(executionSummary.status()).info(executionSummary.info()).error(executionSummary.error()).executionId(executionSummary.executionId()).testCaseTitle(executionSummary.testCaseTitle()).environment(executionSummary.environment()).user(executionSummary.user()).build();
    }

    public static List<ExecutionHistory.ExecutionSummary> fromDto(Collection<ExecutionSummaryDto> executionSummaryList) {
        return executionSummaryList.stream().map(ExecutionSummaryDto::fromDto).collect(Collectors.toList());
    }

    public static ExecutionHistory.ExecutionSummary fromDto(ExecutionSummaryDto dto) {
        return ImmutableExecutionHistory.ExecutionSummary.builder().time(dto.time()).duration(dto.duration()).status(dto.status()).info(dto.info()).error(dto.error()).executionId(dto.executionId()).testCaseTitle(dto.testCaseTitle()).environment(dto.environment()).user(dto.user()).build();
    }
}

