/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.api;

import com.chutneytesting.design.api.campaign.dto.CampaignExecutionReportDto;
import com.chutneytesting.design.api.campaign.dto.CampaignExecutionReportMapper;
import com.chutneytesting.design.domain.campaign.Campaign;
import com.chutneytesting.design.domain.campaign.CampaignExecutionReport;
import com.chutneytesting.design.domain.campaign.CampaignRepository;
import com.chutneytesting.execution.api.report.surefire.SurefireCampaignExecutionReportBuilder;
import com.chutneytesting.execution.api.report.surefire.SurefireScenarioExecutionReportBuilder;
import com.chutneytesting.execution.domain.campaign.CampaignExecutionEngine;
import com.chutneytesting.execution.domain.report.ServerReportStatus;
import com.chutneytesting.security.domain.UserService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/campaign/execution/v1"})
@CrossOrigin(origins={"*"})
public class CampaignExecutionUiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CampaignExecutionUiController.class);
    static final String BASE_URL = "/api/ui/campaign/execution/v1";
    private final CampaignExecutionEngine campaignExecutionEngine;
    private final SurefireCampaignExecutionReportBuilder surefireCampaignExecutionReportBuilder;
    private final CampaignRepository campaignRepository;
    private final UserService userService;

    public CampaignExecutionUiController(CampaignExecutionEngine campaignExecutionEngine, SurefireScenarioExecutionReportBuilder surefireScenarioExecutionReportBuilder, CampaignRepository campaignRepository, UserService userService) {
        this.campaignExecutionEngine = campaignExecutionEngine;
        this.surefireCampaignExecutionReportBuilder = new SurefireCampaignExecutionReportBuilder(surefireScenarioExecutionReportBuilder);
        this.campaignRepository = campaignRepository;
        this.userService = userService;
    }

    @GetMapping(path={"/{campaignName}", "/{campaignName}/{env}"}, produces={"application/json;charset=UTF-8"})
    public List<CampaignExecutionReportDto> executeCampaignByName(@PathVariable(value="campaignName") String campaignName, @PathVariable(value="env") Optional<String> environment) {
        String userId = this.userService.getCurrentUser().getId();
        List<CampaignExecutionReport> reports = environment.isPresent() ? this.campaignExecutionEngine.executeByName(campaignName, environment.get(), userId) : this.campaignExecutionEngine.executeByName(campaignName, userId);
        return reports.stream().map(CampaignExecutionReportMapper::toDto).collect(Collectors.toList());
    }

    @PostMapping(path={"/replay/{campaignExecutionId}"}, produces={"application/json;charset=UTF-8"})
    public CampaignExecutionReportDto replayFailedScenario(@PathVariable(value="campaignExecutionId") Long campaignExecutionId) {
        CampaignExecutionReport campaignExecutionReport = this.campaignRepository.findByExecutionId(campaignExecutionId);
        String userId = this.userService.getCurrentUser().getId();
        List<String> failedIds = campaignExecutionReport.scenarioExecutionReports().stream().filter(s -> !ServerReportStatus.SUCCESS.equals((Object)s.execution.status())).map(s -> s.scenarioId).collect(Collectors.toList());
        Campaign campaign = this.campaignRepository.findById(campaignExecutionReport.campaignId);
        campaign.executionEnvironment(campaignExecutionReport.executionEnvironment);
        CampaignExecutionReport newExecution = this.campaignExecutionEngine.executeScenarioInCampaign(failedIds, campaign, userId);
        return CampaignExecutionReportMapper.toDto(newExecution);
    }

    @GetMapping(path={"/{campaignPattern}/surefire", "/{campaignPattern}/surefire/{env}"}, produces={"application/zip"})
    public byte[] executeCampaignsByPatternWithSurefireReport(HttpServletResponse response, @PathVariable(value="campaignPattern") String campaignPattern, @PathVariable(value="env") Optional<String> environment) {
        String userId = this.userService.getCurrentUser().getId();
        response.addHeader("Content-Disposition", "attachment; filename=\"surefire-report.zip\"");
        List<CampaignExecutionReport> reports = environment.isPresent() ? this.campaignExecutionEngine.executeByName(campaignPattern, environment.get(), userId) : this.campaignExecutionEngine.executeByName(campaignPattern, userId);
        return this.surefireCampaignExecutionReportBuilder.createReport(reports);
    }

    @PostMapping(path={"/{executionId}/stop"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void stopExecution(@PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Stop campaign execution {}", (Object)executionId);
        this.campaignExecutionEngine.stopExecution(executionId);
    }

    @GetMapping(path={"/byID/{campaignId}", "/byID/{campaignId}/{env}"}, produces={"application/json;charset=UTF-8"})
    public CampaignExecutionReportDto executeCampaignById(@PathVariable(value="campaignId") Long campaignId, @PathVariable(value="env") Optional<String> environment) {
        String userId = this.userService.getCurrentUser().getId();
        CampaignExecutionReport report = environment.isPresent() ? this.campaignExecutionEngine.executeById(campaignId, environment.get(), userId) : this.campaignExecutionEngine.executeById(campaignId, userId);
        return CampaignExecutionReportMapper.toDto(report);
    }
}

