/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.jdbc;

import com.chutneytesting.design.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.design.infra.storage.scenario.DelegateScenarioRepository;
import com.chutneytesting.design.infra.storage.scenario.jdbc.ScenarioTagListMapper;
import com.chutneytesting.design.infra.storage.scenario.jdbc.TestCaseData;
import com.chutneytesting.security.domain.User;
import com.chutneytesting.tools.Try;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DatabaseTestCaseRepository
implements DelegateScenarioRepository {
    private static final ScenarioMetadataRowMapper SCENARIO_INDEX_ROW_MAPPER = new ScenarioMetadataRowMapper();
    private final ScenarioRowMapper scenario_row_mapper;
    private final NamedParameterJdbcTemplate uiNamedParameterJdbcTemplate;
    private final ObjectMapper mapper;

    public DatabaseTestCaseRepository(NamedParameterJdbcTemplate uiNamedParameterJdbcTemplate, @Qualifier(value="persistenceObjectMapper") ObjectMapper objectMapper) {
        this.uiNamedParameterJdbcTemplate = uiNamedParameterJdbcTemplate;
        this.mapper = objectMapper;
        this.scenario_row_mapper = new ScenarioRowMapper(this.mapper);
    }

    @Override
    public String alias() {
        return "local";
    }

    @Override
    public String save(TestCaseData scenario) {
        if (this.isNewScenario(scenario)) {
            return this.doSave(scenario);
        }
        return this.doUpdate(scenario);
    }

    @Override
    public Optional<TestCaseData> findById(String scenarioId) {
        try {
            return Optional.of((TestCaseData)this.uiNamedParameterJdbcTemplate.queryForObject("SELECT * FROM SCENARIO WHERE ID = :id and ACTIVATED = TRUE", this.buildIdParameterMap(scenarioId), (RowMapper)this.scenario_row_mapper));
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return Optional.empty();
        }
    }

    @Override
    public List<TestCaseMetadata> findAll() {
        return this.uiNamedParameterJdbcTemplate.query("SELECT ID, TITLE, DESCRIPTION, TAGS, CREATION_DATE, USER_ID, UPDATE_DATE, VERSION FROM SCENARIO where ACTIVATED is TRUE", Collections.emptyMap(), (RowMapper)SCENARIO_INDEX_ROW_MAPPER);
    }

    @Override
    public void removeById(String scenarioId) {
        this.uiNamedParameterJdbcTemplate.update("DELETE FROM CAMPAIGN_EXECUTION_HISTORY WHERE SCENARIO_ID = :id", this.buildIdParameterMap(scenarioId));
        this.uiNamedParameterJdbcTemplate.update("DELETE FROM CAMPAIGN_SCENARIOS WHERE SCENARIO_ID = :id", this.buildIdParameterMap(scenarioId));
        this.uiNamedParameterJdbcTemplate.update("UPDATE SCENARIO SET ACTIVATED = FALSE WHERE ID = :id", this.buildIdParameterMap(scenarioId));
    }

    @Override
    public Optional<Integer> lastVersion(String scenarioId) {
        try {
            return Optional.of((Integer)this.uiNamedParameterJdbcTemplate.queryForObject("SELECT VERSION FROM SCENARIO WHERE ID = :id", this.buildIdParameterMap(scenarioId), Integer.class));
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return Optional.empty();
        }
    }

    private boolean isNewScenario(TestCaseData scenario) {
        return scenario.id == null || (Integer)this.uiNamedParameterJdbcTemplate.queryForObject("SELECT COUNT(ID) FROM SCENARIO WHERE ID = :id", this.buildIdParameterMap(scenario.id), Integer.TYPE) == 0;
    }

    private String doSave(TestCaseData scenario) {
        String nextId = (String)this.uiNamedParameterJdbcTemplate.queryForObject("SELECT nextval('SCENARIO_SEQ')", Collections.emptyMap(), String.class);
        this.uiNamedParameterJdbcTemplate.update("INSERT INTO SCENARIO(CONTENT_VERSION, ID, TITLE, DESCRIPTION, CONTENT, TAGS, CREATION_DATE, DATASET, ACTIVATED, USER_ID, UPDATE_DATE, VERSION) VALUES (:contentVersion, :id, :title, :description, :content, :tags, :creationDate, :dataSet, TRUE, :author, :creationDate, 1)", (SqlParameterSource)this.scenarioQueryParameterMap(nextId, scenario));
        return nextId;
    }

    private String doUpdate(TestCaseData scenario) {
        int update = this.uiNamedParameterJdbcTemplate.update("UPDATE SCENARIO SET CONTENT_VERSION = :contentVersion, TITLE = :title, DESCRIPTION = :description, CONTENT = :content, TAGS = :tags, CREATION_DATE = :creationDate, DATASET = :dataSet, USER_ID = :author, UPDATE_DATE = CURRENT_TIMESTAMP, VERSION = VERSION+1 WHERE ID = :id AND VERSION = :version", (SqlParameterSource)this.scenarioQueryParameterMap(scenario.id, scenario));
        if (update == 0) {
            throw new ScenarioNotFoundException(scenario.id, scenario.version);
        }
        return scenario.id;
    }

    private MapSqlParameterSource scenarioQueryParameterMap(String nextId, TestCaseData scenario) {
        return (MapSqlParameterSource)Try.exec(() -> new MapSqlParameterSource().addValue("contentVersion", (Object)scenario.contentVersion).addValue("id", (Object)nextId).addValue("title", (Object)scenario.title).addValue("description", (Object)scenario.description).addValue("dataSet", (Object)this.mapper.writeValueAsString(scenario.dataSet)).addValue("content", (Object)scenario.rawScenario).addValue("creationDate", (Object)Date.from(scenario.creationDate)).addValue("tags", (Object)ScenarioTagListMapper.tagsListToString(scenario.tags)).addValue("author", (Object)(User.isAnonymous(scenario.author) ? null : scenario.author)).addValue("version", (Object)scenario.version)).runtime();
    }

    private ImmutableMap<String, Object> buildIdParameterMap(String scenarioId) {
        return ImmutableMap.builder().put((Object)"id", (Object)scenarioId).build();
    }

    private static class ScenarioRowMapper
    implements RowMapper<TestCaseData> {
        private final ObjectMapper mapper;

        private ScenarioRowMapper(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        public TestCaseData mapRow(ResultSet rs, int rowNum) throws SQLException {
            TestCaseData.TestCaseDataBuilder testCaseDataBuilder = TestCaseData.builder().withContentVersion(rs.getString("CONTENT_VERSION")).withId(rs.getString("ID")).withTitle(rs.getString("TITLE")).withDescription(rs.getString("DESCRIPTION")).withTags(ScenarioTagListMapper.tagsStringToList(rs.getString("TAGS"))).withRawScenario(rs.getString("CONTENT")).withAuthor(rs.getString("USER_ID")).withVersion(rs.getInt("VERSION"));
            Try.exec(() -> {
                TypeReference<Map<String, String>> typeRef = new TypeReference<Map<String, String>>(){};
                String dataSet = rs.getString("DATASET");
                return testCaseDataBuilder.withDataSet((Map)this.mapper.readValue(dataSet != null ? dataSet : "{}", (TypeReference)typeRef));
            }).runtime();
            Timestamp creationDate = rs.getTimestamp("CREATION_DATE");
            testCaseDataBuilder.withCreationDate(creationDate != null ? creationDate.toInstant() : Instant.now().truncatedTo(ChronoUnit.MILLIS));
            Timestamp updateDate = rs.getTimestamp("UPDATE_DATE");
            testCaseDataBuilder.withUpdateDate(updateDate.toInstant());
            return testCaseDataBuilder.build();
        }
    }

    private static class ScenarioMetadataRowMapper
    implements RowMapper<TestCaseMetadata> {
        private ScenarioMetadataRowMapper() {
        }

        public TestCaseMetadata mapRow(ResultSet rs, int rowNum) throws SQLException {
            String id = rs.getString("ID");
            String title = rs.getString("TITLE");
            String description = rs.getString("DESCRIPTION");
            Timestamp creationDate = rs.getTimestamp("CREATION_DATE");
            List<String> tags = ScenarioTagListMapper.tagsStringToList(rs.getString("TAGS"));
            String author = rs.getString("USER_ID");
            Timestamp updateDate = rs.getTimestamp("UPDATE_DATE");
            Integer version = rs.getInt("VERSION");
            return TestCaseMetadataImpl.builder().withId(id).withTitle(title).withDescription(description).withTags(tags).withCreationDate(creationDate != null ? creationDate.toInstant() : Instant.now().truncatedTo(ChronoUnit.MILLIS)).withAuthor(author).withUpdateDate(updateDate.toInstant()).withVersion(version).build();
        }
    }
}

