/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.git.json.versionned;

import com.chutneytesting.design.infra.storage.scenario.git.json.versionned.CurrentJsonMapper;
import com.chutneytesting.tools.Try;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

class SimpleCurrentJsonMapper<T>
implements CurrentJsonMapper<T> {
    private final String version;
    private final Class<T> type;
    private final ObjectMapper objectMapper;

    SimpleCurrentJsonMapper(Class<T> type, String version, ObjectMapper objectMapper) {
        this.version = version;
        this.type = type;
        this.objectMapper = objectMapper;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public T readNode(JsonNode node) {
        return (T)Try.unsafe(() -> this.objectMapper.treeToValue((TreeNode)node, this.type));
    }

    @Override
    public JsonNode toNode(T jsonObject) {
        return this.objectMapper.valueToTree(jsonObject);
    }
}

