/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.git.json.versionned;

import com.chutneytesting.design.infra.storage.scenario.git.json.versionned.CurrentJsonMapper;
import com.chutneytesting.design.infra.storage.scenario.git.json.versionned.NoMapperForJsonVersionException;
import com.chutneytesting.design.infra.storage.scenario.git.json.versionned.SimpleCurrentJsonMapper;
import com.chutneytesting.design.infra.storage.scenario.git.json.versionned.VersionnedJson;
import com.chutneytesting.design.infra.storage.scenario.git.json.versionned.VersionnedJsonReader;
import com.chutneytesting.tools.Try;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JsonMapper<T> {
    private final CurrentJsonMapper<T> currentMapper;
    private final Map<String, VersionnedJsonReader<T>> readers;
    private final ObjectMapper jacksonMapper;

    @SafeVarargs
    public JsonMapper(String version, Class<T> type, ObjectMapper jacksonMapper, VersionnedJsonReader<T> ... readers) {
        this(new SimpleCurrentJsonMapper<T>(type, version, jacksonMapper), jacksonMapper, readers);
    }

    @SafeVarargs
    public JsonMapper(CurrentJsonMapper<T> currentMapper, ObjectMapper jacksonMapper, VersionnedJsonReader<T> ... readers) {
        this.currentMapper = currentMapper;
        this.jacksonMapper = jacksonMapper;
        ArrayList<VersionnedJsonReader<T>> readersArray = new ArrayList<VersionnedJsonReader<T>>(Arrays.asList(readers));
        readersArray.add(currentMapper);
        this.readers = readersArray.stream().collect(Collectors.toMap(VersionnedJsonReader::version, Function.identity()));
    }

    public T read(Reader reader) {
        return this.read(reader, null);
    }

    public T read(Reader reader, Function<String, T> recoveringReader) {
        try (Scanner sc = new Scanner(reader);){
            String content = sc.useDelimiter("\\Z").next();
            Try parseExec = Try.exec(() -> this.parseJson(content));
            if (recoveringReader != null) {
                parseExec = parseExec.tryToRecover(Exception.class, e -> recoveringReader.apply(content));
            }
            Object object = parseExec.runtime();
            return (T)object;
        }
    }

    private T parseJson(String content) throws IOException {
        JsonNode jsonNode = this.jacksonMapper.readTree(content);
        VersionnedJson versionnedJson = VersionnedJson.of(jsonNode);
        return this.findJsonMapper(versionnedJson.version).orElseThrow(() -> new NoMapperForJsonVersionException(versionnedJson.version)).readNode(versionnedJson.data);
    }

    private Optional<VersionnedJsonReader<T>> findJsonMapper(String version) {
        return Optional.ofNullable(this.readers.get(version));
    }

    public String write(T toWrite) {
        return (String)Try.unsafe(() -> this.jacksonMapper.writeValueAsString((Object)new VersionnedJson(this.currentMapper.version(), this.currentMapper.toNode(toWrite)).toNode()));
    }
}

