/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.git;

import com.chutneytesting.admin.infra.storage.JsonFilesGitRepository;
import com.chutneytesting.design.infra.storage.scenario.DelegateScenarioRepository;
import com.chutneytesting.design.infra.storage.scenario.git.GitClient;
import com.chutneytesting.design.infra.storage.scenario.git.GitRepository;
import com.chutneytesting.design.infra.storage.scenario.git.GitScenarioRepository;
import com.chutneytesting.design.infra.storage.scenario.git.json.versionned.JsonMapper;
import com.chutneytesting.design.infra.storage.scenario.jdbc.TestCaseData;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;

@Service
public class GitScenarioRepositoryFactory {
    private GitClient gitClient;
    private JsonMapper<TestCaseData> jsonMapper;
    private JsonFilesGitRepository jsonFilesGitRepository;

    public GitScenarioRepositoryFactory(GitClient gitClient, JsonMapper<TestCaseData> jsonMapper, JsonFilesGitRepository jsonFilesGitRepository) {
        this.gitClient = gitClient;
        this.jsonMapper = jsonMapper;
        this.jsonFilesGitRepository = jsonFilesGitRepository;
    }

    public Stream<DelegateScenarioRepository> listGitRepo() {
        return this.jsonFilesGitRepository.listGitRepository().stream().map(this::create);
    }

    private DelegateScenarioRepository create(GitRepository repo) {
        return new GitScenarioRepository(repo, this.gitClient, this.jsonMapper);
    }
}

