/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.git;

import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.design.infra.storage.scenario.DelegateScenarioRepository;
import com.chutneytesting.design.infra.storage.scenario.git.GitClient;
import com.chutneytesting.design.infra.storage.scenario.git.GitRepository;
import com.chutneytesting.design.infra.storage.scenario.git.json.versionned.JsonMapper;
import com.chutneytesting.design.infra.storage.scenario.jdbc.TestCaseData;
import com.chutneytesting.tools.IoUtils;
import com.chutneytesting.tools.Streams;
import com.chutneytesting.tools.Try;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitScenarioRepository
implements DelegateScenarioRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitScenarioRepository.class);
    private final GitRepository gitRepository;
    private final Path localPath;
    private final GitClient gitClient;
    private final JsonMapper<TestCaseData> jsonMapper;

    public GitScenarioRepository(GitRepository gitRepository, GitClient gitClient, JsonMapper<TestCaseData> jsonMapper) {
        this.gitRepository = gitRepository;
        this.gitClient = gitClient;
        this.jsonMapper = jsonMapper;
        this.localPath = gitClient.getGitDirectory(gitRepository.repositoryName).resolve(gitRepository.testSubFolder);
        gitClient.loadRepository(gitRepository.url, gitRepository.repositoryName);
    }

    @Override
    public String alias() {
        return this.gitRepository.repositoryName;
    }

    @Override
    public String save(TestCaseData testCaseData) {
        return (String)Try.unsafe((String)"Cannot save scenario", () -> {
            Path toWrite = this.prepareFile(testCaseData);
            Files.write(toWrite, this.jsonMapper.write(testCaseData).getBytes(), new OpenOption[0]);
            String commitMessage = "Auto commit/push. File committed: /" + testCaseData.title;
            this.gitClient.addCommitPushFile(this.gitRepository.repositoryName, commitMessage);
            return String.valueOf(testCaseData.title.hashCode());
        });
    }

    private Path prepareFile(TestCaseData testCaseData) throws IOException {
        Optional<Path> potentialExistingFile = this.findFile(testCaseData.id);
        Path toWrite = potentialExistingFile.map(path -> path.getParent().resolve(testCaseData.title)).orElse(this.localPath.resolve(testCaseData.title));
        potentialExistingFile.ifPresent(existingFile -> Try.unsafe(() -> {
            if (this.shouldMoveFile(testCaseData.title, existingFile.getFileName().toString())) {
                Files.move(existingFile, toWrite, new CopyOption[0]);
            }
        }));
        if (!Files.exists(toWrite, new LinkOption[0])) {
            Files.createFile(toWrite, new FileAttribute[0]);
        }
        return toWrite;
    }

    @Override
    public Optional<TestCaseData> findById(String scenarioId) {
        return this.findFile(scenarioId).map(file -> (TestCaseData)Try.unsafe(() -> this.read((Path)file)));
    }

    private TestCaseData read(Path file) throws IOException {
        try (FileReader reader = new FileReader(file.toFile());){
            TestCaseData testCaseData = this.jsonMapper.read(reader, json -> TestCaseDataMapper.mapFile(file));
            return testCaseData;
        }
    }

    @Override
    public List<TestCaseMetadata> findAll() {
        return (List)Try.unsafe((String)("Cannot browse " + this.localPath), () -> {
            this.gitClient.loadRepository(this.gitRepository.url, this.gitRepository.repositoryName);
            try (Stream<Path> paths = Files.walk(this.localPath, new FileVisitOption[0]);){
                List list = paths.filter(path -> path.toFile().isFile() && !IoUtils.isHidden(path, this.localPath)).map(path -> ScenarioMetadataMapper.mapFile(path, this.alias())).collect(Collectors.toList());
                return list;
            }
        });
    }

    @Override
    public void removeById(String scenarioId) {
        Try.unsafe(() -> {
            Optional<Path> path = this.findFile(scenarioId);
            if (path.isPresent()) {
                Files.delete(path.get());
                this.gitClient.removeCommitPushFile(this.gitRepository.repositoryName, "Delete file" + path.get(), path.get().toFile().getName());
            }
        });
    }

    @Override
    public Optional<Integer> lastVersion(String scenarioId) {
        return Optional.empty();
    }

    private Optional<Path> findFile(String scenarioId) {
        Optional optional;
        block8: {
            Stream<Path> stream = Files.walk(this.localPath, new FileVisitOption[0]);
            try {
                optional = (Optional)stream.filter(path -> path.toFile().isFile() && String.valueOf(path.toFile().getName().hashCode()).equals(scenarioId)).collect(Streams.collectUniqueResult());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot find file", e);
                }
            }
            stream.close();
        }
        return optional;
    }

    private boolean shouldMoveFile(String title, String oldFileName) {
        return !oldFileName.equals(title);
    }

    private static Instant getCreationDate(Path path) {
        try {
            BasicFileAttributes attributes = Files.readAttributes(Paths.get(path.toFile().toURI()), BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = attributes.creationTime();
            return fileTime.toInstant();
        }
        catch (IOException e) {
            LOGGER.error("Cannot parse file " + path, (Throwable)e);
            return Instant.MIN;
        }
    }

    private static class ScenarioMetadataMapper {
        private ScenarioMetadataMapper() {
        }

        static TestCaseMetadata mapFile(Path path, String origin) {
            String id = String.valueOf(path.toFile().getName().hashCode());
            String title = path.toFile().getName();
            String description = "";
            return TestCaseMetadataImpl.builder().withId(id).withTitle(title).withDescription(description).withCreationDate(GitScenarioRepository.getCreationDate(path)).withRepositorySource(origin).build();
        }
    }

    private static class TestCaseDataMapper {
        private TestCaseDataMapper() {
        }

        static TestCaseData mapFile(Path path) {
            try {
                return TestCaseData.builder().withContentVersion("GIT").withId(String.valueOf(path.toFile().getName().hashCode())).withTitle(path.toFile().getName()).withCreationDate(GitScenarioRepository.getCreationDate(path)).withDescription("").withTags(Collections.emptyList()).withDataSet(Collections.emptyMap()).withRawScenario(new String(Files.readAllBytes(path))).build();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot parse file " + path, e);
            }
        }
    }
}

