/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.git;

import com.chutneytesting.tools.Try;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GitClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitClient.class);

    public void loadRepository(String repoUrl, String repoName) {
        File directory = this.getGitDirectory(repoName).toFile();
        if (!this.isValidGitRoot(directory.getPath())) {
            this.cloneRepository(repoUrl, repoName);
        }
        try {
            this.updateRepository(this.getGit(directory), repoName);
        }
        catch (IOException e) {
            LOGGER.error("Cannot update repoository " + repoName, (Throwable)e);
        }
    }

    public void removeCommitPushFile(String repoName, String commitMessage, String fileName) {
        Consumer<Git> consumer = git -> Try.exec(() -> git.rm().addFilepattern(fileName).call());
        this.doThenCommitAndPush(repoName, commitMessage, consumer);
    }

    public void addCommitPushFile(String repoName, String commitMessage) {
        Consumer<Git> consumer = git -> Try.exec(() -> git.add().addFilepattern(".").call());
        this.doThenCommitAndPush(repoName, commitMessage, consumer);
    }

    private void doThenCommitAndPush(String repoName, String commitMessage, Consumer<Git> stageFile) {
        try {
            Git git = this.getGit(this.getGitDirectory(repoName).toFile());
            stageFile.accept(git);
            git.commit().setMessage(commitMessage).call();
            if (git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call().size() > 0) {
                this.updateRepository(git, repoName);
                ((PushCommand)git.push().setTransportConfigCallback(this.getTransportConfigCallback(repoName))).setRemote("origin").call();
            }
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException("Cannot commit: <" + commitMessage + "> to repo: " + repoName, e);
        }
    }

    public Path getGitDirectory(String repoName) {
        return Paths.get(System.getProperty("user.home"), new String[0]).resolve(repoName);
    }

    private void updateRepository(Git git, String repoName) throws IOException {
        try {
            ((FetchCommand)git.fetch().setTransportConfigCallback(this.getTransportConfigCallback(repoName))).call();
            git.merge().setFastForward(MergeCommand.FastForwardMode.FF_ONLY).setCommit(false).include(git.getRepository().findRef("HEAD")).call();
        }
        catch (GitAPIException e) {
            LOGGER.warn("Cannot fetch/merge repository: " + git.getRepository() + ". " + e.getMessage());
        }
    }

    private void cloneRepository(String repoUrl, String repoName) {
        try {
            Path repoDirectory = this.getGitDirectory(repoName);
            Files.createDirectories(repoDirectory, new FileAttribute[0]);
            ((CloneCommand)Git.cloneRepository().setTransportConfigCallback(this.getTransportConfigCallback(repoName))).setURI(repoUrl).setDirectory(repoDirectory.toFile()).call();
        }
        catch (IOException | GitAPIException e) {
            LOGGER.warn("Cannot clone repository: " + repoUrl + ". " + e.getMessage());
        }
    }

    private Git getGit(File directory) throws IOException {
        try {
            Repository repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(directory)).build();
            return new Git(repository);
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Cannnot find git repository at " + directory + ". I will try to create it for you.");
            return this.initLocalRepository(directory);
        }
    }

    private Git initLocalRepository(File directory) {
        try {
            return Git.init().setDirectory(directory).call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException("Cannot create git repository at path : " + directory);
        }
    }

    private boolean isValidGitRoot(String path) {
        File gitRoot = new File(path);
        if (!gitRoot.isDirectory()) {
            return false;
        }
        File gitDirectoryInRoot = new File(gitRoot, ".git");
        return gitDirectoryInRoot.isDirectory();
    }

    private TransportConfigCallback getTransportConfigCallback(final String repoName) {
        return transport -> ((SshTransport)transport).setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host hc, Session session) {
                session.setConfig("StrictHostKeyChecking", "no");
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                JSch defaultJSch = super.createDefaultJSch(fs);
                if (Files.exists(Paths.get("/home/webadm/.ssh/id_rsa_" + repoName, new String[0]), new LinkOption[0])) {
                    defaultJSch.addIdentity("/home/webadm/.ssh/id_rsa_" + repoName);
                }
                return defaultJSch;
            }
        });
    }
}

