/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.compose.orient.changelog;

import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientUtils;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.changelog.ChangelogOrder;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.changelog.OrientChangelog;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OrientChangelogExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientChangelogExecutor.class);
    public static final String DBCHANGELOG_CLASS = "DBChangeLog";

    public void updateWithChangelog(ODatabasePool dbPool) {
        this.initChangeLogClass(dbPool);
        try {
            OrientChangelogExecutor.filterFStepSchemaScripts().forEach(method -> {
                try (ODatabaseSession dbSession = dbPool.acquire();){
                    this.executeChangelog((Method)method, dbSession);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Orient database update failed");
            throw new RuntimeException("Orient database update failed", e);
        }
        LOGGER.info("Orient database update finished");
    }

    public static Stream<Method> filterFStepSchemaScripts() {
        Method[] methods = OrientChangelog.class.getMethods();
        return Arrays.stream(methods).filter(m -> m.getDeclaredAnnotation(ChangelogOrder.class) != null).sorted(Comparator.comparing(value -> value.getDeclaredAnnotation(ChangelogOrder.class).order()));
    }

    private void initChangeLogClass(ODatabasePool dbPool) {
        try (ODatabaseSession dbSession = dbPool.acquire();){
            OClass changeLogClass = dbSession.getClass(DBCHANGELOG_CLASS);
            if (changeLogClass == null) {
                dbSession.command("CREATE CLASS DBChangeLog CLUSTERS 1", new Object[0]);
                LOGGER.debug("Creation of class : {}", (Object)DBCHANGELOG_CLASS);
            }
        }
    }

    private void executeChangelog(Method method, ODatabaseSession dbSession) throws Exception {
        String changelogId = method.getDeclaredAnnotation(ChangelogOrder.class).uuid();
        if (this.shouldExecuteChangelog(dbSession, changelogId)) {
            method.invoke(null, dbSession);
            this.insertChangeLog(dbSession, changelogId);
        }
    }

    private boolean shouldExecuteChangelog(ODatabaseSession dbSession, String name) {
        return OrientUtils.resultSetToCount(dbSession.query("SELECT COUNT(*) as count FROM DBChangeLog WHERE name = ?", new Object[]{name})) == 0L;
    }

    private void insertChangeLog(ODatabaseSession dbSession, String name) {
        OResultSet ignored = dbSession.command("INSERT INTO DBChangeLog (name, executed) VALUES ('" + name + "', sysdate().format('yyyyMMddHHmmssSSS'))", new Object[0]);
        if (ignored != null) {
            ignored.close();
        }
    }
}

