/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.compose.orient.changelog;

import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientUtils;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.changelog.ChangelogOrder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientChangelog {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientChangelog.class);

    @ChangelogOrder(order=2, uuid="20190424-create-newmodel")
    public static void createModel(ODatabaseSession dbSession) {
        OClass funcStepVClass = OrientUtils.createClass("FuncStep", "V", 1, dbSession);
        OProperty nameProperty = funcStepVClass.createProperty("name", OType.STRING);
        nameProperty.setMandatory(true);
        funcStepVClass.createIndex("idx_FuncStep_name", OClass.INDEX_TYPE.UNIQUE.toString(), null, null, "AUTOSHARDING", new String[]{"name"});
        OrientUtils.createClass("Denote", "E", 1, dbSession);
        LOGGER.info("New model created");
    }

    @ChangelogOrder(order=3, uuid="20190515-init-testcase-model")
    public static void initTestCaseModel(ODatabaseSession dbSession) {
        OClass testCaseVClass = OrientUtils.createClass("TestCase", "V", 1, dbSession);
        LOGGER.info("TestCase class created");
    }

    @ChangelogOrder(order=4, uuid="20190611-init-lucene-index")
    public static void initLuceneIndex(ODatabaseSession dbSession) {
    }

    @ChangelogOrder(order=5, uuid="20190828-update-selenium-task-parameters")
    public static void updateSeleniumTaskParameters(ODatabaseSession dbSession) {
    }

    @ChangelogOrder(order=6, uuid="20191127-update-selenium-task-parameters")
    public static void updateSeleniumTaskParametersRight(ODatabaseSession dbSession) {
        String QUERY_FSTEPS_IMPLEMENTATION_ID = "SELECT @rid, implementation FROM FuncStep WHERE implementation is not null";
        OResultSet steps = dbSession.query(QUERY_FSTEPS_IMPLEMENTATION_ID, new Object[0]);
        ObjectMapper objectMapper = new ObjectMapper();
        AtomicInteger countUpdated = new AtomicInteger();
        Lists.newArrayList((Iterator)steps).stream().map(step -> (OVertex)dbSession.load((ORID)new ORecordId(step.getProperty("@rid").toString()))).forEach(step -> {
            try {
                JsonNode implementationNode = objectMapper.readTree(step.getProperty("implementation").toString());
                if (implementationNode != null) {
                    switch (implementationNode.get("identifier").asText()) {
                        case "selenium-get": {
                            OrientChangelog.removeInputsByName(implementationNode, "action", "by", "wait", "switchType", "menuItemSelector");
                            break;
                        }
                        case "selenium-scroll-to": 
                        case "selenium-get-text": 
                        case "selenium-click": 
                        case "selenium-hover-then-click": {
                            OrientChangelog.removeInputsByName(implementationNode, "action", "value", "switchType", "menuItemSelector");
                            break;
                        }
                        case "selenium-send-keys": 
                        case "selenium-wait": {
                            OrientChangelog.removeInputsByName(implementationNode, "action", "switchType", "menuItemSelector");
                            break;
                        }
                        case "selenium-switch-to": {
                            OrientChangelog.removeInputsByName(implementationNode, "action", "value", "menuItemSelector");
                        }
                    }
                }
                step.setProperty("implementation", (Object)objectMapper.writeValueAsString((Object)implementationNode));
                step.save();
                countUpdated.incrementAndGet();
            }
            catch (Exception e) {
                LOGGER.error("Cannot read/write implementation", (Throwable)e);
            }
        });
        LOGGER.info(countUpdated.get() + " selenium tasks updated");
    }

    private static void removeInputsByName(JsonNode node, String ... inputsNames) {
        block3: {
            JsonNode inputsNode;
            block2: {
                inputsNode = node.get("inputs");
                if (!inputsNode.isArray()) break block2;
                List<String> inputsNamesList = Arrays.asList(inputsNames);
                ArrayNode inputs = (ArrayNode)node.get("inputs");
                for (int i = inputs.size() - 1; i >= 0; --i) {
                    JsonNode input = inputs.get(i);
                    if (!inputsNamesList.contains(input.get("name").asText())) continue;
                    inputs.remove(i);
                }
                break block3;
            }
            if (!inputsNode.isObject()) break block3;
            for (String inputName : inputsNames) {
                ((ObjectNode)inputsNode).remove(inputName);
            }
        }
    }

    @ChangelogOrder(order=7, uuid="2020127-update-component-strategies")
    public static void updateComponentStrategies(ODatabaseSession dbSession) {
        try (OResultSet steps = dbSession.query("SELECT FROM FuncStep WHERE `strategy` is null", new Object[0]);){
            steps.stream().filter(o -> o.getProperty("strategy") == null).map(OResult::getVertex).forEach(ov -> ov.ifPresent(v -> {
                OElement strategy = dbSession.newElement();
                strategy.setProperty("name", (Object)"", new OType[]{OType.STRING});
                strategy.setProperty("parameters", Collections.emptyMap(), new OType[]{OType.EMBEDDEDMAP});
                v.setProperty("strategy", (Object)strategy, new OType[]{OType.EMBEDDED});
                v.save();
            }));
        }
        steps = dbSession.query("SELECT FROM FuncStep WHERE `strategy` is not null", new Object[0]);
        try {
            steps.stream().filter(o -> o.getProperty("strategy") != null).filter(o -> ((OResult)o.getProperty("strategy")).hasProperty("data")).map(OResult::getVertex).forEach(ov -> ov.ifPresent(v -> {
                OElement strategy = dbSession.newElement();
                strategy.setProperty("name", (Object)"Loop", new OType[]{OType.STRING});
                strategy.setProperty("parameters", Collections.singletonMap("data", ((OElement)v.getProperty("strategy")).getProperty("data")), new OType[]{OType.EMBEDDEDMAP});
                v.setProperty("strategy", (Object)strategy, new OType[]{OType.EMBEDDED});
                v.save();
            }));
        }
        finally {
            if (steps != null) {
                steps.close();
            }
        }
        steps = dbSession.query("SELECT FROM FuncStep WHERE `strategy` is not null", new Object[0]);
        try {
            steps.stream().filter(o -> o.getProperty("strategy") != null).filter(o -> ((OResult)o.getProperty("strategy")).hasProperty("retryDelay")).map(OResult::getVertex).forEach(ov -> ov.ifPresent(v -> {
                HashMap<String, Object> parameters = new HashMap<String, Object>(2);
                parameters.put("timeOut", ((OElement)v.getProperty("strategy")).getProperty("timeOut"));
                parameters.put("retryDelay", ((OElement)v.getProperty("strategy")).getProperty("retryDelay"));
                OElement strategy = dbSession.newElement();
                strategy.setProperty("name", (Object)"retry-with-timeout", new OType[]{OType.STRING});
                strategy.setProperty("parameters", parameters, new OType[]{OType.EMBEDDEDMAP});
                v.setProperty("strategy", (Object)strategy, new OType[]{OType.EMBEDDED});
                v.save();
            }));
        }
        finally {
            if (steps != null) {
                steps.close();
            }
        }
    }

    @ChangelogOrder(order=8, uuid="20200217-change-lucene-index-analyzer")
    public static void changeLuceneIndexAnalyzer(ODatabaseSession dbSession) {
    }

    @ChangelogOrder(order=9, uuid="20200424-init-dataset-model")
    public static void initDataSetModel(ODatabaseSession dbSession) {
        OrientUtils.createClass("DataSet", null, 1, dbSession);
        OClass oDataSetHistoryClass = OrientUtils.createClass("DataSetHistory", null, 0, dbSession);
        OProperty refIdProperty = oDataSetHistoryClass.createProperty("dataSetId", OType.LINK);
        refIdProperty.setMandatory(true);
        oDataSetHistoryClass.createIndex("idx_DataSetHistory_dataSetId", OClass.INDEX_TYPE.NOTUNIQUE.toString(), null, null, "AUTOSHARDING", new String[]{"dataSetId"});
        LOGGER.info("DataSet model created");
    }

    @ChangelogOrder(order=10, uuid="20201028-init-testcase-updateDate")
    public static void initTestCaseUpdateDate(ODatabaseSession dbSession) {
        try (OResultSet testcases = dbSession.query("SELECT FROM TestCase", new Object[0]);){
            testcases.stream().map(OResult::getElement).forEach(tc -> tc.ifPresent(e -> {
                Optional<Object> creationDate = Optional.ofNullable(e.getProperty("created"));
                if (creationDate.isPresent()) {
                    e.setProperty("updated", creationDate.get(), new OType[]{OType.DATETIME});
                    e.save();
                } else {
                    LOGGER.warn("TestCase " + e.getIdentity().toString() + " does not have a creation date");
                }
            }));
        }
        LOGGER.info("TestCase update date initialized");
    }
}

