/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.compose.orient;

import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientConfigurationProperties;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OrientDBManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientDBManager.class);
    private OrientConfigurationProperties orientConfigurationProperties;
    private OrientDB orientDB;
    private Map<String, ODatabasePool> dbPools = new HashMap<String, ODatabasePool>();

    public OrientDBManager(OrientConfigurationProperties orientConfigurationProperties) {
        this.orientConfigurationProperties = orientConfigurationProperties;
    }

    @PostConstruct
    public void init() {
        this.openEmbeddedOrient();
    }

    @PreDestroy
    public void destroy() {
        this.closePools();
        this.closeEmbeddedOrient();
    }

    public void createOrientDB(String dbName, ODatabaseType dbtype) {
        if (this.orientDB.createIfNotExists(dbName, dbtype)) {
            LOGGER.info("Database created : {} {}", (Object)dbName, (Object)dbtype);
        } else {
            LOGGER.warn("Database already exists : {}. Type {} cannot be garanteed...", (Object)dbName, (Object)dbtype);
        }
        ODatabasePool dbPool = new ODatabasePool(this.orientDB, dbName, "admin", "admin", this.contextConfiguration());
        this.dbPools.put(dbName, dbPool);
    }

    public void backupOrientDB(String dbName, OutputStream outputStream) throws UncheckedIOException {
        ODatabasePool oDatabasePool = this.dbPools.get(dbName);
        Optional.ofNullable(oDatabasePool).ifPresent(pool -> {
            try (ODatabaseSession dbSession = pool.acquire();){
                dbSession.backup(outputStream, Collections.emptyMap(), null, arg_0 -> ((Logger)LOGGER).debug(arg_0), 9, 1024);
            }
            catch (IOException e) {
                LOGGER.error("Backup database [{}] failed : ", (Object)dbName, (Object)e);
                throw new UncheckedIOException(e);
            }
        });
    }

    public ODatabasePool getDBPool(String dbName) {
        return this.dbPools.get(dbName);
    }

    public void dropOrientDB(String dbName) {
        if (this.dbPools.containsKey(dbName)) {
            this.dbPools.get(dbName).close();
            this.dbPools.remove(dbName);
            this.orientDB.drop(dbName);
            LOGGER.info("Database dropped : {}", (Object)dbName);
        }
    }

    private void openEmbeddedOrient() {
        OGlobalConfiguration.setConfiguration(this.orientConfigurationProperties.getContextConfiguration());
        this.orientDB = new OrientDB("embedded:" + this.orientConfigurationProperties.getPath(), this.contextConfiguration());
        LOGGER.info("Orient opened");
    }

    private void closePools() {
        this.dbPools.values().forEach(ODatabasePool::close);
        LOGGER.info("Pools closed");
    }

    private void closeEmbeddedOrient() {
        if (this.orientDB != null) {
            this.orientDB.close();
            LOGGER.info("Orient closed");
        }
    }

    private OrientDBConfig contextConfiguration() {
        return OrientDBConfig.builder().fromMap(this.orientConfigurationProperties.getContextConfiguration()).build();
    }
}

