/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.compose;

import com.chutneytesting.execution.domain.compiler.ScenarioConversionException;
import com.chutneytesting.execution.domain.scenario.composed.StepImplementation;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class RawImplementationMapper {
    private final ObjectMapper objectMapper;

    public RawImplementationMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public StepImplementation deserialize(String rawImplementation) {
        JsonNode implementation;
        try {
            implementation = this.objectMapper.readTree(rawImplementation);
        }
        catch (IOException e) {
            throw new ScenarioConversionException(e);
        }
        return new StepImplementation(this.type(implementation), this.target(implementation), this.inputs(implementation), this.outputs(implementation));
    }

    private String type(JsonNode implementation) {
        if (implementation.hasNonNull("identifier")) {
            return implementation.get("identifier").textValue();
        }
        return null;
    }

    private String target(JsonNode implementation) {
        return Optional.ofNullable(implementation.get("target")).orElse((JsonNode)TextNode.valueOf((String)"")).textValue();
    }

    private Map<String, Object> outputs(JsonNode implementation) {
        LinkedHashMap<String, Object> outputs = new LinkedHashMap<String, Object>();
        if (implementation.hasNonNull("outputs")) {
            JsonNode outputsNode = implementation.get("outputs");
            outputsNode.forEach(in -> {
                String name = in.get("key").asText();
                outputs.put(name, in.get("value").asText());
            });
        }
        return outputs;
    }

    private Map<String, Object> inputs(JsonNode implementation) {
        LinkedHashMap<String, Object> inputs = new LinkedHashMap<String, Object>();
        if (implementation.hasNonNull("inputs")) {
            JsonNode simpleInputs = implementation.get("inputs");
            simpleInputs.forEach(in -> {
                String inputName = in.get("name").asText();
                inputs.put(inputName, this.transformSimpleInputValue((JsonNode)in));
            });
        }
        if (implementation.hasNonNull("listInputs")) {
            JsonNode listInputs = implementation.get("listInputs");
            listInputs.forEach(in -> {
                ArrayList values = new ArrayList();
                in.get("values").forEach(v -> values.add(this.transformListInputValue((JsonNode)v)));
                inputs.put(in.get("name").asText(), values);
            });
        }
        if (implementation.hasNonNull("mapInputs")) {
            JsonNode mapInputs = implementation.get("mapInputs");
            mapInputs.forEach(in -> {
                LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
                for (JsonNode next : in.get("values")) {
                    values.put(next.get("key").asText(), next.get("value").asText());
                }
                inputs.put(in.get("name").asText(), values);
            });
        }
        return inputs;
    }

    private Object transformSimpleInputValue(JsonNode in) {
        String value = in.get("value").asText();
        return !value.isEmpty() ? value : null;
    }

    private Object transformListInputValue(JsonNode in) {
        if (in.isObject()) {
            try {
                return this.objectMapper.readValue(in.toString(), HashMap.class);
            }
            catch (Exception e) {
                return in.toString();
            }
        }
        return in.asText();
    }
}

