/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.compose;

import com.chutneytesting.design.domain.scenario.AlreadyExistingScenarioException;
import com.chutneytesting.design.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.compose.ComposableTestCase;
import com.chutneytesting.design.domain.scenario.compose.ComposableTestCaseRepository;
import com.chutneytesting.design.infra.storage.scenario.compose.ExecutableComposedTestCaseMapper;
import com.chutneytesting.design.infra.storage.scenario.compose.OrientComposableTestCaseMapper;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientComponentDB;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientUtils;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedTestCase;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedTestCaseRepository;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrientComposableTestCaseRepository
implements ComposableTestCaseRepository,
ExecutableComposedTestCaseRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientComposableTestCaseRepository.class);
    private ODatabasePool componentDBPool;
    private ExecutableComposedTestCaseMapper testCaseMapper;
    private static final String QUERY_SELECT_ALL = "SELECT @rid FROM TestCase";

    public OrientComposableTestCaseRepository(OrientComponentDB orientComponentDB, ExecutableComposedTestCaseMapper testCaseMapper) {
        this.componentDBPool = orientComponentDB.dbPool();
        this.testCaseMapper = testCaseMapper;
    }

    @Override
    public String save(ComposableTestCase composableTestCase) {
        ODatabaseSession dbSession = null;
        OVertex savedFStep = null;
        try {
            dbSession = this.componentDBPool.acquire();
            dbSession.begin();
            savedFStep = this.save(composableTestCase, dbSession);
            dbSession.commit();
            LOGGER.debug("Save scenario :" + savedFStep.toString());
            String string = savedFStep.getIdentity().toString();
            return string;
        }
        catch (ORecordDuplicatedException e) {
            OrientUtils.rollback(dbSession);
            throw new AlreadyExistingScenarioException(e.getMessage());
        }
        catch (OConcurrentModificationException e) {
            OrientUtils.rollback(dbSession);
            throw new ScenarioNotFoundException(composableTestCase.id, savedFStep.getVersion());
        }
        catch (ScenarioNotFoundException e) {
            OrientUtils.rollback(dbSession);
            throw e;
        }
        catch (Exception e) {
            OrientUtils.rollback(dbSession);
            throw new RuntimeException(e);
        }
        finally {
            OrientUtils.close(dbSession);
        }
    }

    @Override
    public ComposableTestCase findById(String composableTestCaseId) {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OVertex element = (OVertex)OrientUtils.load(composableTestCaseId, dbSession).orElseThrow(() -> new ScenarioNotFoundException(composableTestCaseId));
            ComposableTestCase composableTestCase = OrientComposableTestCaseMapper.vertexToTestCase(element, dbSession);
            return composableTestCase;
        }
    }

    @Override
    public ExecutableComposedTestCase findExecutableById(String composableTestCaseId) {
        ComposableTestCase composableTestCase = this.findById(composableTestCaseId);
        return this.testCaseMapper.composableToExecutable(composableTestCase);
    }

    @Override
    public List<TestCaseMetadata> findAll() {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OResultSet allSteps = dbSession.query(QUERY_SELECT_ALL, new Object[0]);
            List<TestCaseMetadata> list = Lists.newArrayList((Iterator)allSteps).stream().map(rs -> {
                OVertex element = (OVertex)dbSession.load((ORID)new ORecordId(rs.getProperty("@rid").toString()));
                return OrientComposableTestCaseMapper.vertexToTestCase((OVertex)element, (ODatabaseSession)dbSession).metadata;
            }).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void removeById(String testCaseId) {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OrientUtils.deleteVertex(testCaseId, dbSession);
        }
    }

    @Override
    public Integer lastVersion(String composableTestCaseId) {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OVertex element = (OVertex)OrientUtils.load(composableTestCaseId, dbSession).orElseThrow(() -> new ScenarioNotFoundException(composableTestCaseId));
            Integer n = element.getVersion();
            return n;
        }
    }

    private OVertex save(ComposableTestCase composableTestCase, ODatabaseSession dbSession) {
        Optional<OElement> stepRecord = OrientUtils.load(composableTestCase.id, dbSession);
        if (stepRecord.isPresent() && stepRecord.get().getVersion() != composableTestCase.metadata.version().intValue()) {
            throw new ScenarioNotFoundException(composableTestCase.id, composableTestCase.metadata.version());
        }
        OVertex testCase = (OVertex)stepRecord.orElseGet(() -> dbSession.newVertex("TestCase"));
        OrientComposableTestCaseMapper.testCaseToVertex(composableTestCase, testCase, dbSession);
        return (OVertex)testCase.save();
    }
}

