/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.compose;

import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.design.domain.scenario.compose.ComposableScenario;
import com.chutneytesting.design.domain.scenario.compose.ComposableStep;
import com.chutneytesting.design.domain.scenario.compose.ComposableTestCase;
import com.chutneytesting.design.infra.storage.scenario.compose.OrientComposableStepMapper;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientUtils;
import com.chutneytesting.security.domain.User;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;

class OrientComposableTestCaseMapper {
    OrientComposableTestCaseMapper() {
    }

    static void testCaseToVertex(ComposableTestCase composableTestCase, OVertex dbTestCase, ODatabaseSession dbSession) {
        dbTestCase.setProperty("title", (Object)composableTestCase.metadata.title(), new OType[]{OType.STRING});
        OrientUtils.setOrRemoveProperty((OElement)dbTestCase, "description", composableTestCase.metadata.description(), OType.STRING);
        OrientUtils.setOnlyOnceProperty((OElement)dbTestCase, "created", Date.from(composableTestCase.metadata.creationDate()), OType.DATETIME);
        dbTestCase.setProperty("tags", composableTestCase.metadata.tags(), new OType[]{OType.EMBEDDEDLIST});
        OrientUtils.setOrRemoveProperty((OElement)dbTestCase, "parameters", composableTestCase.composableScenario.parameters, OType.EMBEDDEDMAP);
        OrientUtils.setOrRemoveProperty((OElement)dbTestCase, "datasetId", composableTestCase.metadata.datasetId().orElse(null), OType.STRING);
        dbTestCase.setProperty("updated", (Object)Date.from(Instant.now()), new OType[]{OType.DATETIME});
        OrientUtils.setOrRemoveProperty((OElement)dbTestCase, "author", composableTestCase.metadata.author(), a -> !User.isAnonymous(a), OType.STRING);
        OrientComposableStepMapper.setComposableStepVertexDenotations(dbTestCase, composableTestCase.composableScenario.composableSteps, dbSession);
    }

    static ComposableTestCase vertexToTestCase(OVertex dbTestCase, ODatabaseSession dbSession) {
        TestCaseMetadataImpl metadata = TestCaseMetadataImpl.builder().withId(dbTestCase.getIdentity().toString()).withTitle((String)dbTestCase.getProperty("title")).withDescription((String)dbTestCase.getProperty("description")).withCreationDate(((Date)dbTestCase.getProperty("created")).toInstant()).withRepositorySource("ComposableTestCase").withTags((List)dbTestCase.getProperty("tags")).withDatasetId((String)dbTestCase.getProperty("datasetId")).withUpdateDate(((Date)dbTestCase.getProperty("updated")).toInstant()).withAuthor((String)dbTestCase.getProperty("author")).withVersion(dbTestCase.getVersion()).build();
        List<ComposableStep> composableStepRefs = OrientComposableStepMapper.buildComposableStepsChildren(dbTestCase, dbSession);
        Map parameters = (Map)dbTestCase.getProperty("parameters");
        return new ComposableTestCase(dbTestCase.getIdentity().toString(), metadata, ComposableScenario.builder().withComposableSteps(composableStepRefs).withParameters(parameters).build());
    }
}

