/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.compose;

import com.chutneytesting.design.domain.scenario.compose.AlreadyExistingComposableStepException;
import com.chutneytesting.design.domain.scenario.compose.ComposableStep;
import com.chutneytesting.design.domain.scenario.compose.ComposableStepCyclicDependencyException;
import com.chutneytesting.design.domain.scenario.compose.ComposableStepNotFoundException;
import com.chutneytesting.design.domain.scenario.compose.ComposableStepRepository;
import com.chutneytesting.design.domain.scenario.compose.ParentStepId;
import com.chutneytesting.design.infra.storage.scenario.compose.ExecutableComposedStepMapper;
import com.chutneytesting.design.infra.storage.scenario.compose.OrientComposableStepMapper;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientComponentDB;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientUtils;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedStep;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableStepRepository;
import com.chutneytesting.tools.ImmutablePaginatedDto;
import com.chutneytesting.tools.PaginatedDto;
import com.chutneytesting.tools.PaginationRequestParametersDto;
import com.chutneytesting.tools.SortRequestParametersDto;
import com.chutneytesting.tools.SqlUtils;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrientComposableStepRepository
implements ComposableStepRepository,
ExecutableStepRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientComposableStepRepository.class);
    private final ODatabasePool componentDBPool;
    private final ExecutableComposedStepMapper composedStepMapper;
    private static final String QUERY_SELECT_ALL = "SELECT @rid FROM FuncStep";
    private static final String FIND_PARENTS_STEP = "select @rid, name, title, @class from (TRAVERSE in(Denote) FROM ?) where $depth = 1";

    public OrientComposableStepRepository(OrientComponentDB orientComponentDB, ExecutableComposedStepMapper mapper) {
        this.componentDBPool = orientComponentDB.dbPool();
        this.composedStepMapper = mapper;
    }

    @Override
    public String save(ComposableStep composableStep) {
        LOGGER.debug("Step save " + composableStep.name);
        ODatabaseSession dbSession = null;
        try {
            dbSession = this.componentDBPool.acquire();
            dbSession.begin();
            OVertex savedFStep = this.save(composableStep, dbSession);
            this.checkComposableStepCyclicDependency(savedFStep);
            dbSession.commit();
            LOGGER.debug("Save step : " + savedFStep.toString());
            String string = savedFStep.getIdentity().toString(null).toString();
            return string;
        }
        catch (ORecordDuplicatedException e) {
            OrientUtils.rollback(dbSession);
            throw new AlreadyExistingComposableStepException(composableStep);
        }
        catch (ComposableStepCyclicDependencyException e) {
            OrientUtils.rollback(dbSession);
            throw e;
        }
        catch (Exception e) {
            OrientUtils.rollback(dbSession);
            throw new RuntimeException(e);
        }
        finally {
            OrientUtils.close(dbSession);
        }
    }

    @Override
    public ComposableStep findById(String recordId) {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OVertex element = (OVertex)OrientUtils.load(recordId, dbSession).orElseThrow(() -> new ComposableStepNotFoundException(recordId));
            ComposableStep composableStep = OrientComposableStepMapper.vertexToComposableStep(element, dbSession).build();
            return composableStep;
        }
    }

    @Override
    public ExecutableComposedStep findExecutableById(String recordId) {
        ComposableStep composableStep = this.findById(recordId);
        return this.composedStepMapper.composableToExecutable(composableStep);
    }

    @Override
    public void deleteById(String recordId) {
        ODatabaseSession dbSession = null;
        try {
            dbSession = this.componentDBPool.acquire();
            dbSession.begin();
            OrientUtils.deleteVertex(recordId, dbSession);
            dbSession.commit();
            LOGGER.debug("Delete step : " + recordId);
        }
        catch (Exception e) {
            OrientUtils.rollback(dbSession);
            throw new RuntimeException(e);
        }
        finally {
            OrientUtils.close(dbSession);
        }
    }

    @Override
    public List<ComposableStep> findAll() {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OResultSet allSteps = dbSession.query(QUERY_SELECT_ALL, new Object[0]);
            List<ComposableStep> list = Lists.newArrayList((Iterator)allSteps).stream().map(rs -> {
                OVertex element = (OVertex)dbSession.load((ORID)new ORecordId(rs.getProperty("@rid").toString()));
                return OrientComposableStepMapper.vertexToComposableStep(element, dbSession).build();
            }).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public PaginatedDto<ComposableStep> find(PaginationRequestParametersDto paginationParameters, SortRequestParametersDto sortParameters, ComposableStep filters) {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            ImmutablePaginatedDto<ComposableStep> immutablePaginatedDto;
            block19: {
                long totalCount;
                String query = this.buildPaginatedQuery(filters, sortParameters);
                try (OResultSet rs = dbSession.query(SqlUtils.count(query), new Object[0]);){
                    totalCount = OrientUtils.resultSetToCount(rs);
                }
                rs = dbSession.query(OrientUtils.addPaginationParameters(query), new Object[]{paginationParameters.start() - 1L, paginationParameters.limit()});
                try {
                    List fSteps = Lists.newArrayList((Iterator)rs).stream().filter(e -> e.getVertex().isPresent()).map(element -> OrientComposableStepMapper.vertexToComposableStep((OVertex)element.getVertex().get(), dbSession).build()).collect(Collectors.toList());
                    immutablePaginatedDto = ImmutablePaginatedDto.builder().totalCount(totalCount).addAllData(fSteps).build();
                    if (rs == null) break block19;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return immutablePaginatedDto;
        }
    }

    @Override
    public List<ParentStepId> findParents(String stepId) {
        block14: {
            try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
                Optional<OElement> stepRecord = OrientUtils.load(stepId, dbSession);
                if (!stepRecord.isPresent()) break block14;
                ArrayList<ParentStepId> funcStepIds = new ArrayList<ParentStepId>();
                try (OResultSet rs = dbSession.query(FIND_PARENTS_STEP, new Object[]{stepRecord.get().getIdentity()});){
                    while (rs.hasNext()) {
                        OResult res = rs.next();
                        if (res.getProperty("@class").equals("FuncStep")) {
                            funcStepIds.add(new ParentStepId(res.getProperty("@rid").toString(), (String)res.getProperty("name"), false));
                            continue;
                        }
                        funcStepIds.add(new ParentStepId(res.getProperty("@rid").toString(), (String)res.getProperty("title"), true));
                    }
                }
                ArrayList<ParentStepId> arrayList = funcStepIds;
                return arrayList;
            }
        }
        throw new ComposableStepNotFoundException(stepId);
    }

    private OVertex save(ComposableStep composableStep, ODatabaseSession dbSession) {
        Optional<OElement> stepRecord = OrientUtils.load(composableStep.id, dbSession);
        OVertex step = (OVertex)stepRecord.orElse((OElement)dbSession.newVertex("FuncStep"));
        OrientComposableStepMapper.composableStepToVertex(composableStep, step, dbSession);
        this.updateParentsDataSets(composableStep, step);
        return (OVertex)step.save();
    }

    private void updateParentsDataSets(ComposableStep composableStep, OVertex step) {
        step.getEdges(ODirection.IN, new String[]{"Denote"}).forEach(parentEdge -> {
            Map dataSet = (Map)parentEdge.getProperty("parameters");
            if (dataSet != null) {
                HashMap newDataSet = new HashMap();
                composableStep.parameters.forEach((paramKey, paramValue) -> newDataSet.put(paramKey, dataSet.getOrDefault(paramKey, paramValue)));
                parentEdge.setProperty("parameters", newDataSet);
                parentEdge.save();
            }
        });
    }

    private void checkComposableStepCyclicDependency(OVertex savedFStep) {
        this.checkCyclicDependency(savedFStep, new ArrayList<ORecordId>());
    }

    private void checkCyclicDependency(OVertex savedFStep, List<ORecordId> parentsIds) {
        parentsIds.add((ORecordId)savedFStep.getIdentity());
        ArrayList children = new ArrayList();
        savedFStep.getEdges(ODirection.OUT, new String[]{"Denote"}).forEach(oEdge -> children.add(oEdge.getTo()));
        if (children.size() > 0) {
            ArrayList<ORecordId> childrenIds = new ArrayList<ORecordId>();
            for (OElement child : children) {
                childrenIds.add((ORecordId)child.getIdentity());
            }
            if (childrenIds.removeAll(parentsIds)) {
                throw new ComposableStepCyclicDependencyException((String)savedFStep.getProperty("name"));
            }
            children.forEach(oElement -> this.checkCyclicDependency((OVertex)oElement, (List<ORecordId>)new ArrayList<ORecordId>(parentsIds)));
        }
    }

    private String buildPaginatedQuery(ComposableStep findParameters, SortRequestParametersDto sortParameters) {
        StringBuilder query = new StringBuilder("SELECT FROM ").append("FuncStep").append(" WHERE 1=1");
        if (StringUtils.isNotEmpty((CharSequence)findParameters.name)) {
            query.append(" AND name CONTAINSTEXT '").append(findParameters.name).append("'");
        }
        findParameters.usage.ifPresent(stepUsage -> query.append(" AND ").append("usage").append("='").append(stepUsage.name()).append("'"));
        List<String> sortAttributes = sortParameters.sortParameters();
        List<String> descAttributes = sortParameters.descParameters();
        sortAttributes.forEach(sortAttribute -> {
            query.append(" ORDER BY ").append((String)sortAttribute);
            if (descAttributes.contains(sortAttribute)) {
                query.append(" DESC");
            }
        });
        return query.toString();
    }
}

