/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario.compose;

import com.chutneytesting.design.domain.scenario.compose.ComposableStep;
import com.chutneytesting.design.domain.scenario.compose.StepUsage;
import com.chutneytesting.design.domain.scenario.compose.Strategy;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientUtils;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientComposableStepMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientComposableStepMapper.class);

    static void composableStepToVertex(ComposableStep composableStep, OVertex step, ODatabaseSession dbSession) {
        step.setProperty("name", (Object)composableStep.name, new OType[]{OType.STRING});
        OrientUtils.setOrRemoveProperty((OElement)step, "usage", composableStep.usage, OType.STRING);
        OrientUtils.setOrRemoveProperty((OElement)step, "implementation", composableStep.implementation, OType.STRING);
        OrientUtils.setOrRemoveProperty((OElement)step, "tags", composableStep.tags, OType.EMBEDDEDLIST);
        OElement strategy = dbSession.newElement();
        strategy.setProperty("name", (Object)composableStep.strategy.type, new OType[]{OType.STRING});
        strategy.setProperty("parameters", composableStep.strategy.parameters, new OType[]{OType.EMBEDDEDMAP});
        OrientUtils.setOrRemoveProperty((OElement)step, "strategy", strategy, OType.EMBEDDED);
        step.setProperty("parameters", composableStep.parameters, new OType[]{OType.EMBEDDEDMAP});
        OrientComposableStepMapper.setComposableStepVertexDenotations(step, composableStep.steps, dbSession);
    }

    static void setComposableStepVertexDenotations(OVertex vertex, List<ComposableStep> edgesToSave, ODatabaseSession dbSession) {
        vertex.getEdges(ODirection.OUT, new String[]{"Denote"}).forEach(ORecord::delete);
        IntStream.range(0, edgesToSave.size()).forEach(index -> {
            ComposableStep subComposableStepRef = (ComposableStep)edgesToSave.get(index);
            OVertex dbSubComposableStep = (OVertex)OrientUtils.load(subComposableStepRef.id, dbSession).orElseThrow(() -> new IllegalArgumentException("Functional step with id [" + subComposableStepRef.id + "] does not exists"));
            Map<String, String> subComposableStepDataSet = OrientComposableStepMapper.vertexToDataSet(dbSubComposableStep, dbSession);
            Map<String, String> parameters = OrientComposableStepMapper.cleanChildOverloadedParametersMap(subComposableStepRef.dataSet, subComposableStepDataSet);
            OEdge childEdge = vertex.addEdge(dbSubComposableStep, "Denote");
            childEdge.setProperty("rank", (Object)index);
            if (!parameters.isEmpty()) {
                childEdge.setProperty("parameters", parameters, new OType[]{OType.EMBEDDEDMAP});
            }
            childEdge.save();
        });
    }

    private static Map<String, String> cleanChildOverloadedParametersMap(Map<String, String> instanceDataSet, Map<String, String> dbDataSet) {
        return instanceDataSet.entrySet().stream().filter(entry -> dbDataSet.containsKey(entry.getKey())).filter(entry -> !((String)dbDataSet.get(entry.getKey())).equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static ComposableStep.ComposableStepBuilder vertexToComposableStep(OVertex vertex, ODatabaseSession dbSession) {
        OrientUtils.reloadIfDirty((OElement)vertex);
        ComposableStep.ComposableStepBuilder builder = ComposableStep.builder().withId(vertex.getIdentity().toString()).withName((String)vertex.getProperty("name")).withTags((List)vertex.getProperty("tags"));
        String usage = (String)vertex.getProperty("usage");
        Optional.ofNullable(usage).ifPresent(u -> builder.withUsage(Optional.of(StepUsage.valueOf(u))));
        builder.withImplementation(Optional.ofNullable((String)vertex.getProperty("implementation")));
        Map parameters = (Map)vertex.getProperty("parameters");
        Optional.ofNullable(parameters).ifPresent(builder::addParameters);
        OElement strategy = (OElement)vertex.getProperty("strategy");
        Optional.ofNullable(strategy).ifPresent(s -> builder.withStrategy(new Strategy((String)strategy.getProperty("name"), (Map)strategy.getProperty("parameters"))));
        builder.withSteps(OrientComposableStepMapper.buildComposableStepsChildren(vertex, dbSession));
        Optional.ofNullable(parameters).ifPresent(builder::addDataSet);
        return builder;
    }

    static List<ComposableStep> buildComposableStepsChildren(OVertex vertex, ODatabaseSession dbSession) {
        return StreamSupport.stream(vertex.getEdges(ODirection.OUT, new String[]{"Denote"}).spliterator(), false).filter(childEdge -> {
            Optional<OVertex> to = Optional.ofNullable(childEdge.getTo());
            if (!to.isPresent()) {
                LOGGER.warn("Ignoring edge {} with no to vertex", childEdge);
            }
            return to.isPresent();
        }).map(childEdge -> {
            ComposableStep.ComposableStepBuilder childBuilder = OrientComposableStepMapper.vertexToComposableStep(childEdge.getTo(), dbSession);
            OrientComposableStepMapper.overwriteDataSetWithEdgeParameters(childEdge, childBuilder);
            return childBuilder.build();
        }).collect(Collectors.toList());
    }

    private static void overwriteDataSetWithEdgeParameters(OEdge childEdge, ComposableStep.ComposableStepBuilder builder) {
        Optional.ofNullable((Map)childEdge.getProperty("parameters")).ifPresent(builder::addDataSet);
    }

    private static Map<String, String> vertexToDataSet(OVertex vertex, ODatabaseSession dbSession) {
        OrientUtils.reloadIfDirty((OElement)vertex);
        Map<String, String> dataSet = OrientComposableStepMapper.mergeComposableStepsChildrenDatasets(vertex, dbSession);
        Map parameters = (Map)vertex.getProperty("parameters");
        Optional.ofNullable(parameters).ifPresent(dataSet::putAll);
        return dataSet;
    }

    private static Map<String, String> mergeComposableStepsChildrenDatasets(OVertex vertex, ODatabaseSession dbSession) {
        return StreamSupport.stream(vertex.getEdges(ODirection.OUT, new String[]{"Denote"}).spliterator(), false).map(childEdge -> {
            Map<String, String> dataSet = OrientComposableStepMapper.vertexToDataSet(childEdge.getTo(), dbSession);
            Optional.ofNullable((Map)childEdge.getProperty("parameters")).ifPresent(dataSet::putAll);
            return dataSet;
        }).reduce(new HashMap(), (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        });
    }
}

