/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.scenario;

import com.chutneytesting.design.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.design.domain.scenario.TestCase;
import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.design.domain.scenario.TestCaseRepository;
import com.chutneytesting.design.domain.scenario.gwt.GwtTestCase;
import com.chutneytesting.design.infra.storage.scenario.DelegateScenarioRepository;
import com.chutneytesting.design.infra.storage.scenario.compose.OrientComposableTestCaseRepository;
import com.chutneytesting.design.infra.storage.scenario.git.GitScenarioRepositoryFactory;
import com.chutneytesting.design.infra.storage.scenario.jdbc.DatabaseTestCaseRepository;
import com.chutneytesting.design.infra.storage.scenario.jdbc.TestCaseData;
import com.chutneytesting.design.infra.storage.scenario.jdbc.TestCaseDataMapper;
import com.chutneytesting.documentation.infra.ExamplesRepository;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import com.orientechnologies.orient.core.id.ORecordId;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TestCaseRepositoryAggregator
implements TestCaseRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseRepositoryAggregator.class);
    private DatabaseTestCaseRepository defaultRepository;
    private GitScenarioRepositoryFactory gitScenarioRepositoryFactory;
    private final ExamplesRepository examples;
    private final OrientComposableTestCaseRepository composableTestCaseRepository;

    public TestCaseRepositoryAggregator(DatabaseTestCaseRepository defaultRepository, GitScenarioRepositoryFactory gitScenarioRepositoryFactory, ExamplesRepository examples, OrientComposableTestCaseRepository composableTestCaseRepository) {
        this.defaultRepository = defaultRepository;
        this.gitScenarioRepositoryFactory = gitScenarioRepositoryFactory;
        this.examples = examples;
        this.composableTestCaseRepository = composableTestCaseRepository;
    }

    @Override
    public String save(GwtTestCase testCase) {
        DelegateScenarioRepository repository = this.findRepository(testCase.metadata.repositorySource);
        if (this.savingIsAllowed(repository)) {
            return repository.save(TestCaseDataMapper.toDto(testCase));
        }
        throw new IllegalArgumentException("Saving to repository other than default local is not allowed");
    }

    private boolean savingIsAllowed(DelegateScenarioRepository repository) {
        return repository.alias().equals("local");
    }

    private DelegateScenarioRepository findRepository(String source) {
        return this.repositories().filter(repo -> repo.alias().equals(source)).findFirst().orElse(this.defaultRepository);
    }

    private Stream<DelegateScenarioRepository> repositories() {
        return Stream.concat(Stream.of(this.defaultRepository, this.examples), this.gitScenarioRepositoryFactory.listGitRepo());
    }

    @Override
    public TestCase findById(String scenarioId) {
        if (this.isComposableScenarioId(scenarioId)) {
            return this.composableTestCaseRepository.findExecutableById(scenarioId);
        }
        TestCaseData testCaseData = (TestCaseData)this.repositories().map(repo -> repo.findById(scenarioId)).filter(Optional::isPresent).findFirst().flatMap(tc -> tc).orElseThrow(() -> new ScenarioNotFoundException(scenarioId));
        return TestCaseDataMapper.fromDto(testCaseData);
    }

    @Override
    public TestCaseMetadata findMetadataById(String scenarioId) {
        return this.findById(scenarioId).metadata();
    }

    @Override
    public List<TestCaseMetadata> findAll() {
        List<TestCaseMetadata> testCases = ((Stream)this.repositories().parallel()).flatMap(this::findAllRepositoryStream).collect(Collectors.toList());
        testCases.addAll(this.findAllComposableTestCase());
        return testCases;
    }

    @Override
    public void removeById(String scenarioId) {
        this.defaultRepository.removeById(scenarioId);
    }

    @Override
    public Integer lastVersion(String testCaseId) {
        if (this.isComposableScenarioId(testCaseId)) {
            return this.composableTestCaseRepository.lastVersion(testCaseId);
        }
        return (Integer)this.repositories().map(repo -> repo.lastVersion(testCaseId)).filter(Optional::isPresent).findFirst().flatMap(tc -> tc).orElseThrow(() -> new ScenarioNotFoundException(testCaseId));
    }

    private Stream<? extends TestCaseMetadata> findAllRepositoryStream(DelegateScenarioRepository repository) {
        try {
            return repository.findAll().stream();
        }
        catch (RuntimeException e) {
            LOGGER.warn("Could not aggregate scenarios from repository : " + repository.alias(), (Throwable)e);
            return Stream.empty();
        }
    }

    private boolean isComposableScenarioId(String scenarioId) {
        return ORecordId.isA((String)scenarioId);
    }

    private List<TestCaseMetadata> findAllComposableTestCase() {
        return this.composableTestCaseRepository.findAll().stream().map(testCaseMetadata -> TestCaseMetadataImpl.TestCaseMetadataBuilder.from(testCaseMetadata).withId(ComposableIdUtils.toFrontId(testCaseMetadata.id())).build()).collect(Collectors.toList());
    }
}

