/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.plugins.jira;

import com.chutneytesting.design.domain.plugins.jira.JiraRepository;
import com.chutneytesting.design.domain.plugins.jira.JiraTargetConfiguration;
import com.chutneytesting.tools.ZipUtils;
import com.chutneytesting.tools.file.FileUtils;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JiraFileRepository
implements JiraRepository {
    private static final String FILE_EXTENSION = ".json";
    private static final String SCENARIO_FILE = "scenario_link.json";
    private static final String CAMPAIGN_FILE = "campaign_link.json";
    private static final String CONFIGURATION_FILE = "jira_config.json";
    private static final Path ROOT_DIRECTORY_NAME = Paths.get("jira", new String[0]);
    private final Path storeFolderPath;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    JiraFileRepository(@Value(value="${configuration-folder:conf}") String storeFolderPath) throws UncheckedIOException {
        this.storeFolderPath = Paths.get(storeFolderPath, new String[0]).resolve(ROOT_DIRECTORY_NAME);
        FileUtils.initFolder((Path)this.storeFolderPath);
    }

    @Override
    public void backup(OutputStream outputStream) throws UncheckedIOException {
        try (ZipOutputStream zipOutPut = new ZipOutputStream(new BufferedOutputStream(outputStream, 4096));){
            ZipUtils.compressDirectoryToZipfile(this.storeFolderPath.getParent(), this.storeFolderPath.getFileName(), zipOutPut);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Map<String, String> getAllLinkedCampaigns() {
        return this.getAll(CAMPAIGN_FILE);
    }

    @Override
    public Map<String, String> getAllLinkedScenarios() {
        return this.getAll(SCENARIO_FILE).entrySet().stream().collect(Collectors.toMap(entry -> ComposableIdUtils.toFrontId((String)entry.getKey()), entry -> (String)entry.getValue()));
    }

    @Override
    public String getByScenarioId(String scenarioId) {
        String scenarioIdFormatted = ComposableIdUtils.fromFrontId(scenarioId);
        return this.getById(SCENARIO_FILE, scenarioIdFormatted);
    }

    @Override
    public void saveForScenario(String scenarioFrontId, String jiraId) {
        String scenarioId = ComposableIdUtils.fromFrontId(scenarioFrontId);
        this.save(SCENARIO_FILE, scenarioId, jiraId);
    }

    @Override
    public void removeForScenario(String scenarioId) {
        this.remove(SCENARIO_FILE, ComposableIdUtils.fromFrontId(scenarioId));
    }

    @Override
    public String getByCampaignId(String campaignId) {
        return this.getById(CAMPAIGN_FILE, campaignId);
    }

    @Override
    public void saveForCampaign(String campaignId, String jiraId) {
        this.save(CAMPAIGN_FILE, campaignId, jiraId);
    }

    @Override
    public void removeForCampaign(String campaignId) {
        this.remove(CAMPAIGN_FILE, campaignId);
    }

    @Override
    public JiraTargetConfiguration loadServerConfiguration() {
        return this.doLoadServerConfiguration();
    }

    @Override
    public void saveServerConfiguration(JiraTargetConfiguration jiraTargetConfiguration) {
        Path resolvedFilePath = this.storeFolderPath.resolve(CONFIGURATION_FILE);
        this.doSave(resolvedFilePath, jiraTargetConfiguration);
    }

    private JiraTargetConfiguration doLoadServerConfiguration() {
        Path configurationFilePath = this.storeFolderPath.resolve(CONFIGURATION_FILE);
        if (!Files.exists(configurationFilePath, new LinkOption[0])) {
            return new JiraTargetConfiguration("", "", "");
        }
        try {
            byte[] bytes = Files.readAllBytes(configurationFilePath);
            try {
                return (JiraTargetConfiguration)this.objectMapper.readValue(bytes, JiraTargetConfiguration.class);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot deserialize configuration file: " + configurationFilePath, e);
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + configurationFilePath, e);
        }
    }

    private String getById(String filePath, String id) {
        return this.getAll(filePath).getOrDefault(id, "");
    }

    private Map<String, String> getAll(String filePath) {
        Path resolvedFilePath = this.storeFolderPath.resolve(filePath);
        if (!Files.exists(resolvedFilePath, new LinkOption[0])) {
            return new HashMap<String, String>();
        }
        try {
            byte[] bytes = Files.readAllBytes(resolvedFilePath);
            try {
                Map map = (Map)this.objectMapper.readValue(bytes, Map.class);
                return map;
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot deserialize configuration file: " + resolvedFilePath, e);
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + resolvedFilePath, e);
        }
    }

    private void save(String filePath, String chutneyId, String jiraId) {
        Path resolvedFilePath = this.storeFolderPath.resolve(filePath);
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (Files.exists(resolvedFilePath, new LinkOption[0])) {
                byte[] bytes = Files.readAllBytes(resolvedFilePath);
                map.putAll((Map)this.objectMapper.readValue(bytes, Map.class));
            }
            if (jiraId.isEmpty()) {
                map.remove(chutneyId);
            } else {
                map.put(chutneyId, jiraId);
            }
            this.doSave(resolvedFilePath, map);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + resolvedFilePath, e);
        }
    }

    private void doSave(Path path, Object map) {
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes(map);
            try {
                Files.write(path, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot write in configuration directory: " + this.storeFolderPath, e);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot serialize " + map, e);
        }
    }

    private void remove(String filePath, String chutneyId) {
        Path resolvedFilePath = this.storeFolderPath.resolve(filePath);
        try {
            HashMap map = new HashMap();
            if (Files.exists(resolvedFilePath, new LinkOption[0])) {
                byte[] bytes = Files.readAllBytes(resolvedFilePath);
                map.putAll((Map)this.objectMapper.readValue(bytes, Map.class));
            }
            map.remove(chutneyId);
            this.doSave(resolvedFilePath, map);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + resolvedFilePath, e);
        }
    }
}

