/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.globalvar;

import com.chutneytesting.design.domain.globalvar.GlobalvarRepository;
import com.chutneytesting.tools.ZipUtils;
import com.chutneytesting.tools.file.FileUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.hjson.JsonValue;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileGlobalVarRepository
implements GlobalvarRepository {
    private static final String FILE_EXTENSION = ".hjson";
    static final Path ROOT_DIRECTORY_NAME = Paths.get("global_var", new String[0]);
    private final Path storeFolderPath;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    FileGlobalVarRepository(@Value(value="${configuration-folder:conf}") String storeFolderPath) throws UncheckedIOException {
        this.storeFolderPath = Paths.get(storeFolderPath, new String[0]).resolve(ROOT_DIRECTORY_NAME);
        FileUtils.initFolder((Path)this.storeFolderPath);
    }

    @Override
    public Set<String> list() {
        return (Set)FileUtils.doOnListFiles((Path)this.storeFolderPath, pathStream -> pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(FileUtils::getNameWithoutExtension).sorted(Comparator.naturalOrder()).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    @Override
    public String getFile(String fileName) {
        Path filePath = this.storeFolderPath.resolve(fileName + FILE_EXTENSION);
        this.getFlatMap();
        try {
            return new String(Files.readAllBytes(filePath));
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read " + filePath.toUri().toString(), e);
        }
    }

    @Override
    public void saveFile(String fileName, String hjsonFile) {
        Path filePath = this.storeFolderPath.resolve(fileName + FILE_EXTENSION);
        this.createFile(filePath);
        try {
            Files.write(filePath, hjsonFile.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot save " + filePath.toUri().toString(), e);
        }
    }

    private void createFile(Path filePath) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            try {
                Files.createFile(filePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void deleteFile(String fileName) {
        Path filePath = this.storeFolderPath.resolve(fileName + FILE_EXTENSION);
        try {
            Files.delete(filePath);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot delete " + filePath.toUri().toString(), e);
        }
    }

    @Override
    public Map<String, String> getFlatMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<Path, String> fileContents = this.get();
        fileContents.forEach((path, content) -> {
            try {
                this.addKeys("", this.objectMapper.readTree(JsonValue.readHjson((String)content).toString()), map);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot deserialize global variable file: " + path, e);
            }
        });
        return map;
    }

    public Map<Path, String> get() {
        return (Map)FileUtils.doOnListFiles((Path)this.storeFolderPath, pathStream -> pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(p -> p, FileUtils::readContent)));
    }

    @Override
    public void backup(OutputStream outputStream) throws UncheckedIOException {
        try (ZipOutputStream zipOutPut = new ZipOutputStream(new BufferedOutputStream(outputStream, 4096));){
            Path globalVarDirectoryPath = this.storeFolderPath;
            ZipUtils.compressDirectoryToZipfile(globalVarDirectoryPath.getParent(), globalVarDirectoryPath.getFileName(), zipOutPut);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void addKeys(String currentPath, JsonNode jsonNode, Map<String, String> accumulator) {
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            String pathPrefix = this.getPrefixForObjectNode(currentPath, objectNode);
            Iterator iter = objectNode.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if ("alias".equals(entry.getKey())) continue;
                this.addKeys(pathPrefix + (String)entry.getKey(), (JsonNode)entry.getValue(), accumulator);
            }
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (int i = 0; i < arrayNode.size(); ++i) {
                this.addKeys(currentPath + "[" + i + "]", arrayNode.get(i), accumulator);
            }
        } else if (jsonNode.isValueNode()) {
            ValueNode valueNode = (ValueNode)jsonNode;
            accumulator.put(currentPath, valueNode.asText());
        }
    }

    private String getPrefixForObjectNode(String currentPath, ObjectNode objectNode) {
        Iterator iter = objectNode.fields();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!"alias".equals(entry.getKey())) continue;
            return ((JsonNode)entry.getValue()).asText() + ".";
        }
        return currentPath.isEmpty() ? "" : currentPath + ".";
    }
}

