/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.editionlock;

import com.chutneytesting.design.domain.editionlock.TestCaseEdition;
import com.chutneytesting.design.domain.editionlock.TestCaseEditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class TestCaseEditionsImpl
implements TestCaseEditions {
    private final LoadingCache<TestCaseEdition, TestCaseEdition> editions;

    public TestCaseEditionsImpl(@Value(value="${iceberg.editions.ttl.value:6}") Integer ttlValue, @Value(value="${iceberg.editions.ttl.unit:HOURS}") String ttlUnit) {
        this.editions = CacheBuilder.newBuilder().expireAfterWrite((long)ttlValue.intValue(), TimeUnit.valueOf(ttlUnit)).build((CacheLoader)new CacheLoader<TestCaseEdition, TestCaseEdition>(){

            public TestCaseEdition load(TestCaseEdition key) throws Exception {
                return key;
            }
        });
    }

    @Override
    public List<TestCaseEdition> findAll() {
        return new ArrayList<TestCaseEdition>(this.editions.asMap().values());
    }

    @Override
    public boolean add(TestCaseEdition testCaseEdition) {
        this.editions.getUnchecked((Object)testCaseEdition);
        return true;
    }

    @Override
    public boolean remove(TestCaseEdition testCaseEdition) {
        this.editions.invalidate((Object)testCaseEdition);
        return true;
    }
}

