/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.dataset;

import com.chutneytesting.design.domain.dataset.DataSet;
import com.chutneytesting.design.domain.dataset.DataSetHistoryRepository;
import com.chutneytesting.design.domain.dataset.DataSetNotFoundException;
import com.chutneytesting.design.infra.storage.dataset.DataSetPatch;
import com.chutneytesting.design.infra.storage.dataset.DataSetPatchUtils;
import com.chutneytesting.design.infra.storage.dataset.OrientDataSetHistoryMapper;
import com.chutneytesting.design.infra.storage.dataset.OrientDataSetMapper;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientComponentDB;
import com.chutneytesting.design.infra.storage.scenario.compose.orient.OrientUtils;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrientDataSetHistoryRepository
implements DataSetHistoryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientDataSetHistoryRepository.class);
    private ODatabasePool componentDBPool;
    private static final String QUERY_LAST_VERSION = "SELECT max(version) as maxVersion FROM DataSetHistory WHERE dataSetId = ?";
    private static final String QUERY_ALL_VERSIONS = "SELECT FROM DataSetHistory WHERE dataSetId = ? ORDER BY version";
    private static final String QUERY_FIND_VERSION = "SELECT FROM DataSetHistory WHERE dataSetId = ? AND version <= ? ORDER BY version";
    private static final String QUERY_DELETE_DATASET = "DELETE FROM DataSetHistory WHERE dataSetId = ?";

    public OrientDataSetHistoryRepository(OrientComponentDB orientComponentDB) {
        this.componentDBPool = orientComponentDB.dbPool();
    }

    @Override
    public Integer lastVersion(String dataSetId) {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OResultSet lastVersion = dbSession.query(QUERY_LAST_VERSION, new Object[]{new ORecordId(dataSetId)});
            if (lastVersion.hasNext()) {
                Integer n = (Integer)lastVersion.next().getProperty("maxVersion");
                return n;
            }
            throw new DataSetNotFoundException(dataSetId);
        }
    }

    @Override
    public Optional<Pair<String, Integer>> addVersion(DataSet newDataSet) {
        ODatabaseSession dbSession;
        block5: {
            Optional<Pair<String, Integer>> optional;
            dbSession = null;
            DataSet previousDataSet = null;
            try {
                DataSetPatch dataSetPatch;
                Integer nextVersion = this.nextVersion(newDataSet.id);
                if (nextVersion > 1) {
                    previousDataSet = this.version(newDataSet.id, nextVersion - 1);
                }
                if (!(dataSetPatch = DataSetPatch.builder().fromDataSets(newDataSet, previousDataSet).withRefId(newDataSet.id).withVersion(nextVersion).build()).hasPatchedValues()) break block5;
                dbSession = this.componentDBPool.acquire();
                dbSession.begin();
                OElement oDataSetPatch = (OElement)dbSession.newInstance("DataSetHistory");
                OrientDataSetHistoryMapper.dataSetPatchToElement(dataSetPatch, oDataSetPatch);
                oDataSetPatch.save();
                dbSession.commit();
                LOGGER.info("Save version {} of dataset {}-{}", new Object[]{dataSetPatch.version, dataSetPatch.refId, newDataSet.name});
                optional = Optional.of(Pair.of((Object)oDataSetPatch.getIdentity().toString(null).toString(), (Object)dataSetPatch.version));
            }
            catch (Exception e) {
                try {
                    OrientUtils.rollback(dbSession);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    OrientUtils.close(dbSession);
                    throw throwable;
                }
            }
            OrientUtils.close(dbSession);
            return optional;
        }
        OrientUtils.close(dbSession);
        return Optional.empty();
    }

    @Override
    public Map<Integer, DataSet> allVersions(String dataSetId) {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OResultSet allVersions = dbSession.query(QUERY_ALL_VERSIONS, new Object[]{dataSetId});
            LinkedHashMap<Integer, DataSet> allVersionsMap = new LinkedHashMap<Integer, DataSet>();
            while (allVersions.hasNext()) {
                Optional element = allVersions.next().getElement();
                if (!element.isPresent()) continue;
                OElement oDataSet = (OElement)element.get();
                DataSet.DataSetBuilder dataSetBuilder = OrientDataSetMapper.elementToDataSetMetaDataBuilder(oDataSet).withId(dataSetId);
                allVersionsMap.put((Integer)oDataSet.getProperty("version"), dataSetBuilder.build());
            }
            LinkedHashMap<Integer, DataSet> linkedHashMap = allVersionsMap;
            return linkedHashMap;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataSet version(String dataSetId, Integer version) {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OResultSet query = dbSession.query(QUERY_FIND_VERSION, new Object[]{dataSetId, version});
            if (!query.hasNext()) throw new DataSetNotFoundException(dataSetId);
            DataSet.DataSetBuilder dataSetBuilder = DataSet.builder().withId(dataSetId);
            String datasetValues = "";
            for (OResult rs : Lists.newArrayList((Iterator)query)) {
                Optional element = rs.getElement();
                if (!element.isPresent()) continue;
                DataSetPatch dataSetPatch = OrientDataSetHistoryMapper.elementToDataSetPatch((OElement)element.get());
                if (dataSetPatch.name != null) {
                    dataSetBuilder.withName(dataSetPatch.name);
                }
                if (dataSetPatch.description != null) {
                    dataSetBuilder.withDescription(dataSetPatch.description);
                }
                dataSetBuilder.withCreationDate(dataSetPatch.creationDate.truncatedTo(ChronoUnit.MILLIS));
                if (dataSetPatch.tags != null) {
                    dataSetBuilder.withTags(dataSetPatch.tags);
                }
                datasetValues = DataSetPatchUtils.patchString(datasetValues, dataSetPatch);
            }
            Pair<Map<String, String>, List<Map<String, String>>> values = DataSetPatchUtils.extractValues(datasetValues);
            DataSet dataSet = dataSetBuilder.withUniqueValues((Map)values.getLeft()).withMultipleValues((List)values.getRight()).build();
            return dataSet;
        }
        catch (Exception e) {
            LOGGER.error("Error finding dataset [{}] version {}", new Object[]{dataSetId, version, e});
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeHistory(String dataSetId) {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OResultSet rs = dbSession.command(QUERY_DELETE_DATASET, new Object[]{dataSetId});
            LOGGER.info("Delete {} versions of DataSet {}", (Object)OrientUtils.resultSetToCount(rs), (Object)dataSetId);
        }
    }

    private Integer nextVersion(String dataSetId) {
        try {
            return this.lastVersion(dataSetId) + 1;
        }
        catch (DataSetNotFoundException e) {
            return 1;
        }
    }
}

