/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.campaign;

import com.chutneytesting.design.domain.campaign.SchedulingCampaign;
import com.chutneytesting.design.domain.campaign.SchedulingCampaignRepository;
import com.chutneytesting.design.infra.storage.campaign.SchedulingCampaignDto;
import com.chutneytesting.tools.file.FileUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class SchedulingCampaignFileRepository
implements SchedulingCampaignRepository {
    private static final Path ROOT_DIRECTORY_NAME = Paths.get("scheduling", new String[0]);
    private static final String SCHEDULING_CAMPAIGNS_FILE = "schedulingCampaigns.json";
    private final Path storeFolderPath;
    private final Path resolvedFilePath;
    private final AtomicLong currentMaxId = new AtomicLong();
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().registerModule((Module)new JavaTimeModule()).enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    SchedulingCampaignFileRepository(@Value(value="${configuration-folder:conf}") String storeFolderPath) throws UncheckedIOException {
        this.storeFolderPath = Paths.get(storeFolderPath, new String[0]).resolve(ROOT_DIRECTORY_NAME);
        this.resolvedFilePath = this.storeFolderPath.resolve(SCHEDULING_CAMPAIGNS_FILE);
        FileUtils.initFolder((Path)this.storeFolderPath);
        this.currentMaxId.set(this.getALl().stream().map(sm -> sm.id).max(Long::compare).orElse(0L));
    }

    @Override
    public SchedulingCampaign add(SchedulingCampaign schedulingCampaign) {
        Map<String, SchedulingCampaignDto> schedulingCampaigns = this.readFromDisk();
        long id = this.currentMaxId.incrementAndGet();
        schedulingCampaigns.put(String.valueOf(id), this.toDto(id, schedulingCampaign));
        this.writeOnDisk(this.resolvedFilePath, schedulingCampaigns);
        return schedulingCampaign;
    }

    @Override
    public void removeById(Long id) {
        Map<String, SchedulingCampaignDto> schedulingCampaigns = this.readFromDisk();
        schedulingCampaigns.remove(String.valueOf(id));
        this.writeOnDisk(this.resolvedFilePath, schedulingCampaigns);
    }

    @Override
    public List<SchedulingCampaign> getALl() {
        return this.readFromDisk().entrySet().stream().map(e -> this.fromDto((String)e.getKey(), (SchedulingCampaignDto)e.getValue())).collect(Collectors.toList());
    }

    private Map<String, SchedulingCampaignDto> readFromDisk() {
        HashMap<String, SchedulingCampaignDto> stringSchedulingCampaignDTO = new HashMap<String, SchedulingCampaignDto>();
        try {
            if (Files.exists(this.resolvedFilePath, new LinkOption[0])) {
                byte[] bytes = Files.readAllBytes(this.resolvedFilePath);
                stringSchedulingCampaignDTO.putAll((Map)this.objectMapper.readValue(bytes, (TypeReference)new TypeReference<HashMap<String, SchedulingCampaignDto>>(){}));
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + this.resolvedFilePath, e);
        }
        return stringSchedulingCampaignDTO;
    }

    private void writeOnDisk(Path filePath, Map<String, SchedulingCampaignDto> schedulingCampaignDTO) {
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes(schedulingCampaignDTO);
            try {
                Files.write(filePath, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot write in configuration directory: " + this.storeFolderPath, e);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot serialize " + schedulingCampaignDTO, e);
        }
    }

    private SchedulingCampaign fromDto(String id, SchedulingCampaignDto dto) {
        return new SchedulingCampaign(Long.valueOf(dto.id), dto.campaignId, dto.campaignTitle, dto.schedulingDate);
    }

    private SchedulingCampaignDto toDto(long id, SchedulingCampaign schedulingCampaign) {
        return new SchedulingCampaignDto(String.valueOf(id), schedulingCampaign.campaignId, schedulingCampaign.campaignTitle, schedulingCampaign.schedulingDate);
    }
}

