/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.campaign;

import com.chutneytesting.design.domain.campaign.Campaign;
import com.chutneytesting.design.domain.campaign.CampaignExecutionReport;
import com.chutneytesting.design.domain.campaign.CampaignNotFoundException;
import com.chutneytesting.design.domain.campaign.CampaignRepository;
import com.chutneytesting.design.infra.storage.campaign.CampaignExecutionRepository;
import com.chutneytesting.design.infra.storage.campaign.CampaignParameterRepository;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DatabaseCampaignRepository
implements CampaignRepository {
    private static final CampaignRepositoryRowMapper CAMPAIGN_ENTITY_ROW_MAPPER = new CampaignRepositoryRowMapper();
    private final NamedParameterJdbcTemplate uiNamedParameterJdbcTemplate;
    private final CampaignExecutionRepository campaignExecutionRepository;
    private final CampaignParameterRepository campaignParameterRepository;

    public DatabaseCampaignRepository(NamedParameterJdbcTemplate uiNamedParameterJdbcTemplate, CampaignExecutionRepository campaignExecutionRepository, CampaignParameterRepository campaignParameterRepository) {
        this.uiNamedParameterJdbcTemplate = uiNamedParameterJdbcTemplate;
        this.campaignExecutionRepository = campaignExecutionRepository;
        this.campaignParameterRepository = campaignParameterRepository;
    }

    @Override
    public Campaign createOrUpdate(Campaign campaign) {
        Long id = !this.isCampaignExists(campaign.id) ? this.doSave(campaign) : this.doUpdate(campaign);
        return this.findById(id);
    }

    @Override
    public void saveReport(Long campaignId, CampaignExecutionReport report) {
        this.campaignExecutionRepository.saveCampaignReport(campaignId, report);
    }

    @Override
    public boolean removeById(Long id) {
        if (this.isCampaignExists(id)) {
            this.campaignExecutionRepository.clearAllExecutionHistory(id);
            this.clearAllAssociationToScenario(id);
            this.campaignParameterRepository.clearAllCampaignParameters(id);
            this.deleteCampaign(id);
            return true;
        }
        return false;
    }

    @Override
    public Campaign findById(Long campaignId) throws CampaignNotFoundException {
        Campaign campaign = this.findByIdWithoutExecutions(campaignId);
        Map<String, String> parameters = this.campaignParameterRepository.findCampaignParameters(campaign.id).stream().collect(Collectors.toMap(cp -> cp.parameter, cp -> cp.value));
        return new Campaign(campaign.id, campaign.title, campaign.description, campaign.scenarioIds, parameters, campaign.getScheduleTime(), campaign.executionEnvironment(), campaign.parallelRun, campaign.retryAuto, campaign.datasetId);
    }

    @Override
    public List<Campaign> findByName(String campaignName) {
        String sql = "SELECT C.ID FROM CAMPAIGN C LEFT JOIN CAMPAIGN_SCENARIOS CS ON CS.CAMPAIGN_ID = C.ID WHERE LOWER(C.TITLE) LIKE LOWER(:campaignName) GROUP BY C.ID ";
        return this.uiNamedParameterJdbcTemplate.queryForList(sql, (Map)ImmutableMap.of((Object)"campaignName", (Object)campaignName), Long.class).stream().map(this::findById).collect(Collectors.toList());
    }

    @Override
    public List<CampaignExecutionReport> findLastExecutions(Long numberOfExecution) {
        return this.campaignExecutionRepository.findLastExecutions(numberOfExecution);
    }

    @Override
    public List<String> findScenariosIds(Long campaignId) {
        return this.uiNamedParameterJdbcTemplate.queryForList("SELECT SCENARIO_ID FROM CAMPAIGN_SCENARIOS WHERE CAMPAIGN_ID = :campaignId order by INDEX asc", (Map)ImmutableMap.of((Object)"campaignId", (Object)campaignId), String.class);
    }

    @Override
    public Long newCampaignExecution() {
        return this.campaignExecutionRepository.generateCampaignExecutionId();
    }

    @Override
    public List<Campaign> findAll() {
        String sql = "SELECT DISTINCT C.ID FROM CAMPAIGN C";
        return this.uiNamedParameterJdbcTemplate.queryForList(sql, Collections.emptyMap(), Long.class).stream().map(this::findByIdWithoutExecutions).collect(Collectors.toList());
    }

    @Override
    public List<CampaignExecutionReport> findExecutionsById(Long campaignId) {
        return this.campaignExecutionRepository.findExecutionHistory(campaignId);
    }

    private Long doUpdate(Campaign campaign) {
        this.uiNamedParameterJdbcTemplate.update("UPDATE CAMPAIGN SET TITLE = :title, DESCRIPTION = :description, SCHEDULE_TIME = :scheduletime, ENVIRONMENT = :environment, PARALLEL_RUN = :paralellRun, RETRY_AUTO = :retryAuto, DATASET_ID = :datasetId WHERE ID = :id", DatabaseCampaignRepository.map(Pair.of((Object)"id", (Object)campaign.id), Pair.of((Object)"title", (Object)campaign.title), Pair.of((Object)"description", (Object)campaign.description), Pair.of((Object)"scheduletime", (Object)campaign.getStringScheduleTime()), Pair.of((Object)"environment", (Object)campaign.executionEnvironment()), Pair.of((Object)"paralellRun", (Object)campaign.parallelRun), Pair.of((Object)"retryAuto", (Object)campaign.retryAuto), Pair.of((Object)"datasetId", (Object)campaign.datasetId)));
        this.updateScenarioReferences(campaign.id, campaign.scenarioIds);
        this.campaignParameterRepository.updateCampaignParameter(campaign.id, campaign.dataSet);
        return campaign.id;
    }

    private Long doSave(Campaign unsavedCampaign) {
        Long id = (Long)this.uiNamedParameterJdbcTemplate.queryForObject("SELECT nextval('CAMPAIGN_SEQ')", Collections.emptyMap(), Long.class);
        this.uiNamedParameterJdbcTemplate.update("INSERT INTO CAMPAIGN(ID, TITLE, DESCRIPTION, SCHEDULE_TIME, ENVIRONMENT, PARALLEL_RUN, RETRY_AUTO, DATASET_ID) VALUES (:id, :title, :description, :scheduletime, :environment, :paralellRun, :retryAuto, :datasetId)", DatabaseCampaignRepository.map(Pair.of((Object)"id", (Object)id), Pair.of((Object)"title", (Object)unsavedCampaign.title), Pair.of((Object)"description", (Object)((Serializable)((Object)Optional.ofNullable(unsavedCampaign.description).orElse("")))), Pair.of((Object)"scheduletime", (Object)unsavedCampaign.getStringScheduleTime()), Pair.of((Object)"environment", (Object)unsavedCampaign.executionEnvironment()), Pair.of((Object)"paralellRun", (Object)unsavedCampaign.parallelRun), Pair.of((Object)"retryAuto", (Object)unsavedCampaign.retryAuto), Pair.of((Object)"datasetId", (Object)unsavedCampaign.datasetId)));
        this.updateScenarioReferences(id, unsavedCampaign.scenarioIds);
        this.campaignParameterRepository.updateCampaignParameter(id, unsavedCampaign.dataSet);
        return id;
    }

    private void updateScenarioReferences(Long campaignId, List<String> scenarioId) {
        this.clearAllAssociationToScenario(campaignId);
        AtomicInteger index = new AtomicInteger(0);
        scenarioId.forEach(id -> this.uiNamedParameterJdbcTemplate.update("INSERT INTO CAMPAIGN_SCENARIOS(CAMPAIGN_ID, SCENARIO_ID, INDEX) VALUES (:campaignId, :scenarioId, :index)", DatabaseCampaignRepository.map(Pair.of((Object)"campaignId", (Object)campaignId), Pair.of((Object)"scenarioId", (Object)id), Pair.of((Object)"index", (Object)index.incrementAndGet()))));
    }

    private boolean isCampaignExists(Long campaignId) {
        return Optional.ofNullable(campaignId).map(id -> (Integer)this.uiNamedParameterJdbcTemplate.queryForObject("SELECT COUNT(ID) FROM CAMPAIGN WHERE ID = :id", (Map)ImmutableMap.builder().put((Object)"id", id).build(), Integer.TYPE) > 0).orElse(false);
    }

    private void deleteCampaign(Long id) {
        this.uiNamedParameterJdbcTemplate.update("DELETE FROM CAMPAIGN WHERE ID = :id", (Map)ImmutableMap.of((Object)"id", (Object)id));
    }

    private void clearAllAssociationToScenario(Long id) {
        this.uiNamedParameterJdbcTemplate.update("DELETE FROM CAMPAIGN_SCENARIOS WHERE CAMPAIGN_ID = :campaignId", (Map)ImmutableMap.of((Object)"campaignId", (Object)id));
    }

    private Campaign findByIdWithoutExecutions(Long campaignId) {
        String sql = "SELECT C.* FROM CAMPAIGN C WHERE C.ID = :campaignId ";
        try {
            Campaign campaign = (Campaign)this.uiNamedParameterJdbcTemplate.queryForObject(sql, (Map)ImmutableMap.of((Object)"campaignId", (Object)campaignId), (RowMapper)CAMPAIGN_ENTITY_ROW_MAPPER);
            Optional.ofNullable(campaign).ifPresent(c -> this.findScenariosIds(c.id).forEach(c::addScenario));
            return campaign;
        }
        catch (EmptyResultDataAccessException e) {
            throw new CampaignNotFoundException(campaignId);
        }
    }

    @Override
    public List<Campaign> findCampaignsByScenarioId(String scenarioId) {
        String sqlQuery = "SELECT C.* FROM campaign C INNER JOIN campaign_scenarios ON campaign_scenarios.campaign_id = C.id WHERE scenario_id= :scenarioId";
        return this.uiNamedParameterJdbcTemplate.query(sqlQuery, (Map)ImmutableMap.of((Object)"scenarioId", (Object)scenarioId), (RowMapper)CAMPAIGN_ENTITY_ROW_MAPPER).stream().collect(Collectors.toList());
    }

    @Override
    public CampaignExecutionReport findByExecutionId(Long campaignExecutionId) {
        return this.campaignExecutionRepository.getCampaignExecutionReportsById(campaignExecutionId);
    }

    private static <K, V> Map<K, V> map(Pair<K, V> ... entries) {
        HashMap ret = new HashMap();
        Arrays.stream(entries).forEach(e -> ret.put(e.getKey(), e.getRight()));
        return ret;
    }

    private static class CampaignRepositoryRowMapper
    implements RowMapper<Campaign> {
        private CampaignRepositoryRowMapper() {
        }

        public Campaign mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long id = rs.getLong("ID");
            String title = rs.getString("TITLE");
            String description = rs.getString("DESCRIPTION");
            String scheduleTimeAsString = rs.getString("SCHEDULE_TIME");
            String environment = rs.getString("ENVIRONMENT");
            String datasetId = rs.getString("DATASET_ID");
            Boolean parallelRun = rs.getBoolean("PARALLEL_RUN");
            Boolean retryAuto = rs.getBoolean("RETRY_AUTO");
            LocalTime localTime = scheduleTimeAsString != null ? LocalTime.parse(scheduleTimeAsString, Campaign.formatter) : null;
            return new Campaign(id, title, description, null, null, localTime, environment, parallelRun, retryAuto, datasetId);
        }
    }
}

