/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.domain.scenario.raw;

import com.chutneytesting.design.domain.scenario.TestCase;
import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RawTestCase
implements TestCase {
    public final TestCaseMetadataImpl metadata;
    public final String content;
    private Map<String, String> dataSet;

    public RawTestCase(TestCaseMetadataImpl metadata, String content, Map<String, String> dataSet) {
        this.metadata = metadata;
        this.content = content;
        this.dataSet = dataSet;
    }

    @Override
    public TestCaseMetadata metadata() {
        return this.metadata;
    }

    @Override
    public Map<String, String> computedParameters() {
        return this.dataSet;
    }

    @Override
    public TestCase withDataSet(Map<String, String> dataSet) {
        return RawTestCase.builder().withMetadata(this.metadata).withScenario(this.content).withDataSet(dataSet).build();
    }

    public String toString() {
        return "RawTestCase{metadata=" + this.metadata + ", scenario=" + this.content + ", dataSet=" + this.dataSet + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawTestCase that = (RawTestCase)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.content, that.content) && Objects.equals(this.dataSet, that.dataSet);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.content, this.dataSet);
    }

    public static RawTestCaseBuilder builder() {
        return new RawTestCaseBuilder();
    }

    public static class RawTestCaseBuilder {
        private TestCaseMetadataImpl metadata;
        private String scenario;
        private Map<String, String> dataSet;

        private RawTestCaseBuilder() {
        }

        public RawTestCase build() {
            return new RawTestCase(Optional.ofNullable(this.metadata).orElseGet(() -> TestCaseMetadataImpl.builder().build()), Optional.ofNullable(this.scenario).orElse(""), Optional.ofNullable(this.dataSet).orElse(Collections.emptyMap()));
        }

        public RawTestCaseBuilder withMetadata(TestCaseMetadataImpl metadata) {
            this.metadata = metadata;
            return this;
        }

        public RawTestCaseBuilder withScenario(String scenario) {
            this.scenario = scenario;
            return this;
        }

        public RawTestCaseBuilder withDataSet(Map<String, String> dataSet) {
            this.dataSet = Collections.unmodifiableMap(dataSet);
            return this;
        }
    }
}

