/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.domain.scenario.gwt;

import com.chutneytesting.design.domain.scenario.TestCase;
import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.design.domain.scenario.gwt.GwtScenario;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GwtTestCase
implements TestCase {
    public final TestCaseMetadataImpl metadata;
    public final GwtScenario scenario;
    public final Map<String, String> dataSet;

    private GwtTestCase(TestCaseMetadataImpl metadata, GwtScenario scenario, Map<String, String> dataSet) {
        this.metadata = metadata;
        this.scenario = scenario;
        this.dataSet = dataSet;
    }

    @Override
    public TestCaseMetadata metadata() {
        return this.metadata;
    }

    @Override
    public Map<String, String> computedParameters() {
        return this.dataSet;
    }

    @Override
    public TestCase withDataSet(Map<String, String> dataSet) {
        return GwtTestCase.builder().withMetadata(this.metadata).withScenario(this.scenario).withDataSet(dataSet).build();
    }

    public String toString() {
        return "GwtTestCase{metadata=" + this.metadata + ", scenario=" + this.scenario + ", dataSet=" + this.dataSet + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GwtTestCase that = (GwtTestCase)o;
        return this.metadata.equals(that.metadata) && this.scenario.equals(that.scenario) && this.dataSet.equals(that.dataSet);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.scenario, this.dataSet);
    }

    public static GwtTestCaseBuilder builder() {
        return new GwtTestCaseBuilder();
    }

    public static class GwtTestCaseBuilder {
        private TestCaseMetadataImpl metadata;
        private GwtScenario scenario;
        private Map<String, String> dataSet;

        private GwtTestCaseBuilder() {
        }

        public GwtTestCase build() {
            return new GwtTestCase(this.metadata, this.scenario, Optional.ofNullable(this.dataSet).orElse(Collections.emptyMap()));
        }

        public GwtTestCaseBuilder withMetadata(TestCaseMetadataImpl metadata) {
            this.metadata = metadata;
            return this;
        }

        public GwtTestCaseBuilder withScenario(GwtScenario scenario) {
            this.scenario = scenario;
            return this;
        }

        public GwtTestCaseBuilder withDataSet(Map<String, String> dataSet) {
            this.dataSet = Collections.unmodifiableMap(dataSet);
            return this;
        }
    }
}

