/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.domain.scenario.compose;

import com.chutneytesting.design.domain.scenario.TestCase;
import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.design.domain.scenario.compose.ComposableScenario;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ComposableTestCase
implements TestCase {
    public final String id;
    public final TestCaseMetadata metadata;
    public final ComposableScenario composableScenario;
    public final Map<String, String> computedParameters;

    public ComposableTestCase(String id, TestCaseMetadata metadata, ComposableScenario composableScenario) {
        this.id = id;
        this.metadata = metadata;
        this.composableScenario = composableScenario;
        this.computedParameters = this.buildDataSet();
    }

    public ComposableTestCase(String id, TestCaseMetadata metadata, ComposableScenario composableScenario, Map<String, String> computedParameters) {
        this.id = id;
        this.metadata = metadata;
        this.composableScenario = composableScenario;
        this.computedParameters = computedParameters;
    }

    @Override
    public TestCaseMetadata metadata() {
        return this.metadata;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Map<String, String> computedParameters() {
        return this.computedParameters;
    }

    @Override
    public TestCase withDataSet(Map<String, String> dataSet) {
        return new ComposableTestCase(this.id, this.metadata, this.composableScenario, dataSet);
    }

    public TestCase withDataSetId(String dataSetId) {
        return new ComposableTestCase(this.id, TestCaseMetadataImpl.TestCaseMetadataBuilder.from(this.metadata).withDatasetId(dataSetId).build(), this.composableScenario, this.computedParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComposableTestCase that = (ComposableTestCase)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.composableScenario, that.composableScenario) && Objects.equals(this.computedParameters, that.computedParameters);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.metadata, this.composableScenario, this.computedParameters);
    }

    private Map<String, String> buildDataSet() {
        HashMap<String, String> dataSet = new HashMap<String, String>();
        this.composableScenario.composableSteps.forEach(composableStep -> dataSet.putAll(composableStep.dataSetGlobalParameters()));
        Optional.ofNullable(this.composableScenario.parameters).ifPresent(dataSet::putAll);
        return dataSet;
    }

    public String toString() {
        return "ComposableTestCase{id='" + this.id + "', metadata=" + this.metadata + ", composableScenario=" + this.composableScenario + ", dataSet=" + this.computedParameters + "}";
    }
}

