/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.domain.scenario.compose;

import com.chutneytesting.design.domain.scenario.compose.StepUsage;
import com.chutneytesting.design.domain.scenario.compose.Strategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ComposableStep {
    public final String id;
    public final String name;
    public final List<ComposableStep> steps;
    public final Map<String, String> parameters;
    public final Optional<String> implementation;
    public final Optional<StepUsage> usage;
    public final Strategy strategy;
    public final Map<String, String> dataSet;
    public final List<String> tags;

    private ComposableStep(String id, String name, List<ComposableStep> steps, Map<String, String> parameters, Optional<String> implementation, Optional<StepUsage> usage, Strategy strategy, Map<String, String> dataSet, List<String> tags) {
        this.id = id;
        this.name = name;
        this.steps = steps;
        this.parameters = parameters;
        this.implementation = implementation;
        this.usage = usage;
        this.strategy = strategy;
        this.dataSet = dataSet;
        this.tags = tags;
    }

    public Map<String, String> dataSetGlobalParameters() {
        return this.dataSet.entrySet().stream().filter(e -> StringUtils.isBlank((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static ComposableStepBuilder builder() {
        return new ComposableStepBuilder();
    }

    public String toString() {
        return "ComposableStep{id='" + this.id + "', name='" + this.name + "', steps=" + this.steps + ", parameters=" + this.parameters + ", implementation=" + this.implementation + ", usage=" + this.usage + ", strategy=" + this.strategy.toString() + ", dataSet=" + this.dataSet + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComposableStep that = (ComposableStep)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.steps, that.steps) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.implementation, that.implementation) && Objects.equals(this.usage, that.usage) && Objects.equals(this.strategy, that.strategy) && Objects.equals(this.dataSet, that.dataSet);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.steps, this.parameters, this.implementation, this.usage, this.strategy, this.dataSet);
    }

    public static class ComposableStepBuilder {
        private String id;
        private String name;
        private List<ComposableStep> steps;
        private Map<String, String> parameters = new LinkedHashMap<String, String>();
        private Optional<String> implementation;
        private Optional<StepUsage> usage;
        private Strategy strategy;
        private Map<String, String> dataSet = new LinkedHashMap<String, String>();
        private List<String> tags = new ArrayList<String>();

        private ComposableStepBuilder() {
        }

        public ComposableStep build() {
            return new ComposableStep(Optional.ofNullable(this.id).orElse(""), Optional.ofNullable(this.name).orElse(""), Optional.ofNullable(this.steps).orElse(Collections.emptyList()), Optional.ofNullable(this.parameters).orElse(Collections.emptyMap()), Optional.ofNullable(this.implementation).orElse(Optional.empty()), Optional.ofNullable(this.usage).orElse(Optional.empty()), Optional.ofNullable(this.strategy).orElse(Strategy.DEFAULT), Collections.unmodifiableMap(Optional.ofNullable(this.dataSet).orElse(Collections.emptyMap())), Collections.unmodifiableList(Optional.ofNullable(this.tags).orElse(Collections.emptyList())));
        }

        public ComposableStepBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public ComposableStepBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ComposableStepBuilder withSteps(List<ComposableStep> steps) {
            this.steps = Collections.unmodifiableList(steps);
            steps.forEach(composableStep -> this.addDataSet(composableStep.dataSetGlobalParameters()));
            return this;
        }

        public ComposableStepBuilder withParameters(Map<String, String> parameters) {
            this.parameters = Collections.unmodifiableMap(parameters);
            return this;
        }

        public ComposableStepBuilder overrideDataSetWith(Map<String, String> dataSet) {
            this.dataSet = dataSet;
            return this;
        }

        public ComposableStepBuilder withImplementation(Optional<String> implementation) {
            this.implementation = implementation;
            return this;
        }

        public ComposableStepBuilder withUsage(Optional<StepUsage> usage) {
            this.usage = usage;
            return this;
        }

        public ComposableStepBuilder withStrategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public ComposableStepBuilder addParameters(Map<String, String> parameters) {
            Optional.ofNullable(parameters).ifPresent(this.parameters::putAll);
            return this;
        }

        public ComposableStepBuilder addDataSet(Map<String, String> dataSet) {
            Optional.ofNullable(dataSet).ifPresent(this.dataSet::putAll);
            return this;
        }

        public ComposableStepBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public final ComposableStepBuilder from(ComposableStep instance) {
            this.id = instance.id;
            this.name = instance.name;
            this.steps = instance.steps;
            this.parameters = instance.parameters;
            this.implementation = instance.implementation;
            this.usage = instance.usage;
            this.strategy = instance.strategy;
            this.dataSet = new LinkedHashMap<String, String>(instance.dataSet);
            return this;
        }
    }
}

