/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.domain.scenario.compose;

import com.chutneytesting.design.domain.scenario.compose.ComposableStep;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ComposableScenario {
    public final List<ComposableStep> composableSteps;
    public final Map<String, String> parameters;

    private ComposableScenario(List<ComposableStep> composableSteps, Map<String, String> parameters) {
        this.composableSteps = composableSteps;
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComposableScenario that = (ComposableScenario)o;
        return Objects.equals(this.composableSteps, that.composableSteps) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.composableSteps, this.parameters);
    }

    public String toString() {
        return "ComposableScenario{composableSteps=" + this.composableSteps + ", parameters=" + this.parameters + "}";
    }

    public static ComposableScenarioBuilder builder() {
        return new ComposableScenarioBuilder();
    }

    public static class ComposableScenarioBuilder {
        private List<ComposableStep> composableSteps;
        private Map<String, String> parameters;

        private ComposableScenarioBuilder() {
        }

        public ComposableScenario build() {
            return new ComposableScenario(Optional.ofNullable(this.composableSteps).orElse(Collections.emptyList()), Optional.ofNullable(this.parameters).orElse(Collections.emptyMap()));
        }

        public ComposableScenarioBuilder withComposableSteps(List<ComposableStep> composableSteps) {
            this.composableSteps = composableSteps;
            return this;
        }

        public ComposableScenarioBuilder withParameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }
    }
}

