/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.domain.editionlock;

import com.chutneytesting.design.domain.editionlock.TestCaseEdition;
import com.chutneytesting.design.domain.editionlock.TestCaseEditions;
import com.chutneytesting.design.domain.scenario.TestCaseRepository;
import java.time.Instant;
import java.util.List;

public class TestCaseEditionsService {
    private final TestCaseEditions testCaseEditions;
    private final TestCaseRepository testCaseRepository;

    public TestCaseEditionsService(TestCaseEditions testCaseEditions, TestCaseRepository testCaseRepository) {
        this.testCaseEditions = testCaseEditions;
        this.testCaseRepository = testCaseRepository;
    }

    public List<TestCaseEdition> getTestCaseEditions(String testCaseId) {
        return this.testCaseEditions.findBy(TestCaseEdition.byId(testCaseId));
    }

    public TestCaseEdition editTestCase(String testCaseId, String user) {
        List<TestCaseEdition> edition = this.testCaseEditions.findBy(TestCaseEdition.byId(testCaseId).and(TestCaseEdition.byEditor(user)));
        if (!edition.isEmpty()) {
            return edition.get(0);
        }
        TestCaseEdition testCaseEdition = new TestCaseEdition(this.testCaseRepository.findById(testCaseId).metadata(), Instant.now(), user);
        if (this.testCaseEditions.add(testCaseEdition)) {
            return testCaseEdition;
        }
        throw new IllegalStateException("Cannot lock scenario edition");
    }

    public void endTestCaseEdition(String testCaseId, String user) {
        this.testCaseEditions.findBy(TestCaseEdition.byId(testCaseId).and(TestCaseEdition.byEditor(user))).forEach(this.testCaseEditions::remove);
    }
}

