/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.domain.dataset;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DataSet {
    public final String id;
    public final String name;
    public final String description;
    public final Instant creationDate;
    public final List<String> tags;
    public final Map<String, String> uniqueValues;
    public final List<Map<String, String>> multipleValues;

    private DataSet(String id, String name, String description, Instant creationDate, List<String> tags, Map<String, String> uniqueValues, List<Map<String, String>> multipleValues) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.creationDate = creationDate;
        this.tags = tags;
        this.uniqueValues = uniqueValues;
        this.multipleValues = multipleValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSet dataSet = (DataSet)o;
        return Objects.equals(this.id, dataSet.id) && Objects.equals(this.name, dataSet.name) && Objects.equals(this.description, dataSet.description) && Objects.equals(this.creationDate, dataSet.creationDate) && Objects.equals(this.tags, dataSet.tags) && Objects.equals(this.uniqueValues, dataSet.uniqueValues) && Objects.equals(this.multipleValues, dataSet.multipleValues);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.creationDate, this.tags, this.uniqueValues, this.multipleValues);
    }

    public String toString() {
        return "DataSet{id='" + this.id + "', name='" + this.name + "', description='" + this.description + "', creationDate=" + this.creationDate + ", tags=" + this.tags + ", uniqueValues=" + this.uniqueValues + ", multipleValues=" + this.multipleValues + "}";
    }

    public static DataSetBuilder builder() {
        return new DataSetBuilder();
    }

    public static class DataSetBuilder {
        private static String DEFAULT_ID = "-1";
        private String id;
        private String name;
        private String description;
        private Instant creationDate;
        private List<String> tags;
        private Map<String, String> uniqueValues;
        private List<Map<String, String>> multipleValues;

        private DataSetBuilder() {
        }

        public DataSet build() {
            if (!Objects.isNull(this.id) && this.id.isEmpty()) {
                throw new IllegalArgumentException("DataSet id cannot be empty");
            }
            return new DataSet(Optional.ofNullable(this.id).orElse(DEFAULT_ID), Optional.ofNullable(this.name).orElse(""), Optional.ofNullable(this.description).orElse(""), Optional.ofNullable(this.creationDate).orElseGet(() -> Instant.now().truncatedTo(ChronoUnit.MILLIS)), Optional.ofNullable(this.tags).orElse(Collections.emptyList()).stream().map(String::toUpperCase).map(String::trim).collect(Collectors.toList()), this.cleanUniqueValues(Optional.ofNullable(this.uniqueValues).orElse(Collections.emptyMap())), this.cleanMultipleValues(Optional.ofNullable(this.multipleValues).orElse(Collections.emptyList())));
        }

        public DataSetBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public DataSetBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public DataSetBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public DataSetBuilder withCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public DataSetBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public DataSetBuilder withUniqueValues(Map<String, String> uniqueValues) {
            this.uniqueValues = uniqueValues;
            return this;
        }

        public DataSetBuilder withMultipleValues(List<Map<String, String>> multipleValues) {
            this.multipleValues = multipleValues;
            return this;
        }

        public DataSetBuilder fromDataSet(DataSet dataset) {
            return new DataSetBuilder().withId(dataset.id).withName(dataset.name).withDescription(dataset.description).withCreationDate(dataset.creationDate).withTags(dataset.tags).withUniqueValues(dataset.uniqueValues).withMultipleValues(dataset.multipleValues);
        }

        private Map<String, String> cleanUniqueValues(Map<String, String> uniqueValues) {
            return uniqueValues.entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private List<Map<String, String>> cleanMultipleValues(List<Map<String, String>> multipleValues) {
            return multipleValues.stream().map(this::cleanUniqueValues).filter(this::hasValuesNotBlank).collect(Collectors.toList());
        }

        private boolean hasValuesNotBlank(Map<String, String> map) {
            return map.values().stream().anyMatch(StringUtils::isNotBlank);
        }
    }
}

