/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.v2_0.dto;

import com.chutneytesting.design.api.scenario.v2_0.dto.GwtTestCaseMetadataDto;
import com.chutneytesting.design.api.scenario.v2_0.dto.TestCaseIndexDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableTestCaseIndexDto
implements TestCaseIndexDto {
    private final GwtTestCaseMetadataDto metadata;

    private ImmutableTestCaseIndexDto(GwtTestCaseMetadataDto metadata) {
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public GwtTestCaseMetadataDto metadata() {
        return this.metadata;
    }

    public final ImmutableTestCaseIndexDto withMetadata(GwtTestCaseMetadataDto value) {
        if (this.metadata == value) {
            return this;
        }
        GwtTestCaseMetadataDto newValue = Objects.requireNonNull(value, "metadata");
        return new ImmutableTestCaseIndexDto(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTestCaseIndexDto && this.equalTo((ImmutableTestCaseIndexDto)another);
    }

    private boolean equalTo(ImmutableTestCaseIndexDto another) {
        return this.metadata.equals(another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.metadata.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TestCaseIndexDto").omitNullValues().add("metadata", (Object)this.metadata).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTestCaseIndexDto fromJson(Json json) {
        Builder builder = ImmutableTestCaseIndexDto.builder();
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static ImmutableTestCaseIndexDto copyOf(TestCaseIndexDto instance) {
        if (instance instanceof ImmutableTestCaseIndexDto) {
            return (ImmutableTestCaseIndexDto)instance;
        }
        return ImmutableTestCaseIndexDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METADATA = 1L;
        private long initBits = 1L;
        @Nullable
        private GwtTestCaseMetadataDto metadata;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TestCaseIndexDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.metadata(instance.metadata());
            return this;
        }

        @JsonProperty(value="metadata")
        @CanIgnoreReturnValue
        public final Builder metadata(GwtTestCaseMetadataDto metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTestCaseIndexDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTestCaseIndexDto(this.metadata);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metadata");
            }
            return "Cannot build TestCaseIndexDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements TestCaseIndexDto {
        @Nullable
        GwtTestCaseMetadataDto metadata;

        Json() {
        }

        @JsonProperty(value="metadata")
        public void setMetadata(GwtTestCaseMetadataDto metadata) {
            this.metadata = metadata;
        }

        @Override
        public GwtTestCaseMetadataDto metadata() {
            throw new UnsupportedOperationException();
        }
    }
}

