/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.v2_0.dto;

import com.chutneytesting.design.api.scenario.v2_0.dto.GwtTestCaseMetadataDto;
import com.chutneytesting.execution.api.ExecutionSummaryDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableGwtTestCaseMetadataDto
implements GwtTestCaseMetadataDto {
    @Nullable
    private final String id;
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String repositorySource;
    private final ImmutableList<String> tags;
    private final ImmutableList<ExecutionSummaryDto> executions;
    private final Instant creationDate;

    private ImmutableGwtTestCaseMetadataDto(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.description = builder.description;
        this.repositorySource = builder.repositorySource;
        this.tags = builder.tags.build();
        this.executions = builder.executions.build();
        this.creationDate = builder.creationDate != null ? builder.creationDate : Objects.requireNonNull(GwtTestCaseMetadataDto.super.creationDate(), "creationDate");
    }

    private ImmutableGwtTestCaseMetadataDto(@Nullable String id, String title, @Nullable String description, @Nullable String repositorySource, ImmutableList<String> tags, ImmutableList<ExecutionSummaryDto> executions, Instant creationDate) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.repositorySource = repositorySource;
        this.tags = tags;
        this.executions = executions;
        this.creationDate = creationDate;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="repositorySource")
    public Optional<String> repositorySource() {
        return Optional.ofNullable(this.repositorySource);
    }

    @JsonProperty(value="tags")
    public ImmutableList<String> tags() {
        return this.tags;
    }

    @JsonProperty(value="executions")
    public ImmutableList<ExecutionSummaryDto> executions() {
        return this.executions;
    }

    @Override
    @JsonProperty(value="creationDate")
    public Instant creationDate() {
        return this.creationDate;
    }

    public final ImmutableGwtTestCaseMetadataDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(newValue, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(value, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withTitle(String value) {
        if (this.title.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "title");
        return new ImmutableGwtTestCaseMetadataDto(this.id, newValue, this.description, this.repositorySource, this.tags, this.executions, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, newValue, this.repositorySource, this.tags, this.executions, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, value, this.repositorySource, this.tags, this.executions, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withRepositorySource(String value) {
        String newValue = Objects.requireNonNull(value, "repositorySource");
        if (Objects.equals(this.repositorySource, newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, newValue, this.tags, this.executions, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withRepositorySource(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.repositorySource, value)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, value, this.tags, this.executions, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, (ImmutableList<String>)newValue, this.executions, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, (ImmutableList<String>)newValue, this.executions, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withExecutions(ExecutionSummaryDto ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, this.tags, (ImmutableList<ExecutionSummaryDto>)newValue, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withExecutions(Iterable<? extends ExecutionSummaryDto> elements) {
        if (this.executions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, this.tags, (ImmutableList<ExecutionSummaryDto>)newValue, this.creationDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withCreationDate(Instant value) {
        if (this.creationDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "creationDate");
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGwtTestCaseMetadataDto && this.equalTo((ImmutableGwtTestCaseMetadataDto)another);
    }

    private boolean equalTo(ImmutableGwtTestCaseMetadataDto another) {
        return Objects.equals(this.id, another.id) && this.title.equals(another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.repositorySource, another.repositorySource) && this.tags.equals(another.tags) && this.executions.equals(another.executions) && this.creationDate.equals(another.creationDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.repositorySource);
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.executions.hashCode();
        h += (h << 5) + this.creationDate.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GwtTestCaseMetadataDto").omitNullValues().add("id", (Object)this.id).add("title", (Object)this.title).add("description", (Object)this.description).add("repositorySource", (Object)this.repositorySource).add("tags", this.tags).add("executions", this.executions).add("creationDate", (Object)this.creationDate).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGwtTestCaseMetadataDto fromJson(Json json) {
        Builder builder = ImmutableGwtTestCaseMetadataDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.repositorySource != null) {
            builder.repositorySource(json.repositorySource);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.executions != null) {
            builder.addAllExecutions(json.executions);
        }
        if (json.creationDate != null) {
            builder.creationDate(json.creationDate);
        }
        return builder.build();
    }

    public static ImmutableGwtTestCaseMetadataDto copyOf(GwtTestCaseMetadataDto instance) {
        if (instance instanceof ImmutableGwtTestCaseMetadataDto) {
            return (ImmutableGwtTestCaseMetadataDto)instance;
        }
        return ImmutableGwtTestCaseMetadataDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String repositorySource;
        private ImmutableList.Builder<String> tags = ImmutableList.builder();
        private ImmutableList.Builder<ExecutionSummaryDto> executions = ImmutableList.builder();
        @Nullable
        private Instant creationDate;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GwtTestCaseMetadataDto instance) {
            Optional<String> repositorySourceOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            this.title(instance.title());
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            if ((repositorySourceOptional = instance.repositorySource()).isPresent()) {
                this.repositorySource(repositorySourceOptional);
            }
            this.addAllTags(instance.tags());
            this.addAllExecutions(instance.executions());
            this.creationDate(instance.creationDate());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositorySource(String repositorySource) {
            this.repositorySource = Objects.requireNonNull(repositorySource, "repositorySource");
            return this;
        }

        @JsonProperty(value="repositorySource")
        @CanIgnoreReturnValue
        public final Builder repositorySource(Optional<String> repositorySource) {
            this.repositorySource = repositorySource.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            this.tags.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            this.tags.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExecutions(ExecutionSummaryDto element) {
            this.executions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExecutions(ExecutionSummaryDto ... elements) {
            this.executions.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="executions")
        @CanIgnoreReturnValue
        public final Builder executions(Iterable<? extends ExecutionSummaryDto> elements) {
            this.executions = ImmutableList.builder();
            return this.addAllExecutions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExecutions(Iterable<? extends ExecutionSummaryDto> elements) {
            this.executions.addAll(elements);
            return this;
        }

        @JsonProperty(value="creationDate")
        @CanIgnoreReturnValue
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
            return this;
        }

        public ImmutableGwtTestCaseMetadataDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGwtTestCaseMetadataDto(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build GwtTestCaseMetadataDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GwtTestCaseMetadataDto {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        String title;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Optional<String> repositorySource = Optional.empty();
        @Nullable
        List<String> tags = ImmutableList.of();
        @Nullable
        List<ExecutionSummaryDto> executions = ImmutableList.of();
        @Nullable
        Instant creationDate;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="repositorySource")
        public void setRepositorySource(Optional<String> repositorySource) {
            this.repositorySource = repositorySource;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="executions")
        public void setExecutions(List<ExecutionSummaryDto> executions) {
            this.executions = executions;
        }

        @JsonProperty(value="creationDate")
        public void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> repositorySource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ExecutionSummaryDto> executions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant creationDate() {
            throw new UnsupportedOperationException();
        }
    }
}

