/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.v2_0.dto;

import com.chutneytesting.design.api.scenario.v2_0.dto.GwtStepDto;
import com.chutneytesting.design.api.scenario.v2_0.dto.GwtStepImplementationDto;
import com.chutneytesting.design.api.scenario.v2_0.dto.StrategyDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableGwtStepDto
implements GwtStepDto {
    @Nullable
    private final String sentence;
    private final List<GwtStepDto> subSteps;
    @Nullable
    private final GwtStepImplementationDto implementation;
    @Nullable
    private final StrategyDto strategy;
    @Nullable
    private final String xRef;

    private ImmutableGwtStepDto(@Nullable String sentence, List<GwtStepDto> subSteps, @Nullable GwtStepImplementationDto implementation, @Nullable StrategyDto strategy, @Nullable String xRef) {
        this.sentence = sentence;
        this.subSteps = subSteps;
        this.implementation = implementation;
        this.strategy = strategy;
        this.xRef = xRef;
    }

    @Override
    @JsonProperty(value="sentence")
    public Optional<String> sentence() {
        return Optional.ofNullable(this.sentence);
    }

    @Override
    @JsonProperty(value="subSteps")
    public List<GwtStepDto> subSteps() {
        return this.subSteps;
    }

    @Override
    @JsonProperty(value="implementation")
    public Optional<GwtStepImplementationDto> implementation() {
        return Optional.ofNullable(this.implementation);
    }

    @Override
    @JsonProperty(value="strategy")
    public Optional<StrategyDto> strategy() {
        return Optional.ofNullable(this.strategy);
    }

    @Override
    @JsonProperty(value="x-$ref")
    public Optional<String> xRef() {
        return Optional.ofNullable(this.xRef);
    }

    public final ImmutableGwtStepDto withSentence(String value) {
        String newValue = Objects.requireNonNull(value, "sentence");
        if (Objects.equals(this.sentence, newValue)) {
            return this;
        }
        return new ImmutableGwtStepDto(newValue, this.subSteps, this.implementation, this.strategy, this.xRef);
    }

    public final ImmutableGwtStepDto withSentence(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sentence, value)) {
            return this;
        }
        return new ImmutableGwtStepDto(value, this.subSteps, this.implementation, this.strategy, this.xRef);
    }

    public final ImmutableGwtStepDto withSubSteps(GwtStepDto ... elements) {
        List<GwtStepDto> newValue = ImmutableGwtStepDto.createUnmodifiableList(false, ImmutableGwtStepDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGwtStepDto(this.sentence, newValue, this.implementation, this.strategy, this.xRef);
    }

    public final ImmutableGwtStepDto withSubSteps(Iterable<? extends GwtStepDto> elements) {
        if (this.subSteps == elements) {
            return this;
        }
        List<GwtStepDto> newValue = ImmutableGwtStepDto.createUnmodifiableList(false, ImmutableGwtStepDto.createSafeList(elements, true, false));
        return new ImmutableGwtStepDto(this.sentence, newValue, this.implementation, this.strategy, this.xRef);
    }

    public final ImmutableGwtStepDto withImplementation(GwtStepImplementationDto value) {
        GwtStepImplementationDto newValue = Objects.requireNonNull(value, "implementation");
        if (this.implementation == newValue) {
            return this;
        }
        return new ImmutableGwtStepDto(this.sentence, this.subSteps, newValue, this.strategy, this.xRef);
    }

    public final ImmutableGwtStepDto withImplementation(Optional<? extends GwtStepImplementationDto> optional) {
        GwtStepImplementationDto value = optional.orElse(null);
        if (this.implementation == value) {
            return this;
        }
        return new ImmutableGwtStepDto(this.sentence, this.subSteps, value, this.strategy, this.xRef);
    }

    public final ImmutableGwtStepDto withStrategy(StrategyDto value) {
        StrategyDto newValue = Objects.requireNonNull(value, "strategy");
        if (this.strategy == newValue) {
            return this;
        }
        return new ImmutableGwtStepDto(this.sentence, this.subSteps, this.implementation, newValue, this.xRef);
    }

    public final ImmutableGwtStepDto withStrategy(Optional<? extends StrategyDto> optional) {
        StrategyDto value = optional.orElse(null);
        if (this.strategy == value) {
            return this;
        }
        return new ImmutableGwtStepDto(this.sentence, this.subSteps, this.implementation, value, this.xRef);
    }

    public final ImmutableGwtStepDto withXRef(String value) {
        String newValue = Objects.requireNonNull(value, "xRef");
        if (Objects.equals(this.xRef, newValue)) {
            return this;
        }
        return new ImmutableGwtStepDto(this.sentence, this.subSteps, this.implementation, this.strategy, newValue);
    }

    public final ImmutableGwtStepDto withXRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.xRef, value)) {
            return this;
        }
        return new ImmutableGwtStepDto(this.sentence, this.subSteps, this.implementation, this.strategy, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGwtStepDto && this.equalTo((ImmutableGwtStepDto)another);
    }

    private boolean equalTo(ImmutableGwtStepDto another) {
        return Objects.equals(this.sentence, another.sentence) && this.subSteps.equals(another.subSteps) && Objects.equals(this.implementation, another.implementation) && Objects.equals(this.strategy, another.strategy) && Objects.equals(this.xRef, another.xRef);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sentence);
        h += (h << 5) + this.subSteps.hashCode();
        h += (h << 5) + Objects.hashCode(this.implementation);
        h += (h << 5) + Objects.hashCode(this.strategy);
        h += (h << 5) + Objects.hashCode(this.xRef);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GwtStepDto{");
        if (this.sentence != null) {
            builder.append("sentence=").append(this.sentence);
        }
        if (builder.length() > 11) {
            builder.append(", ");
        }
        builder.append("subSteps=").append(this.subSteps);
        if (this.implementation != null) {
            builder.append(", ");
            builder.append("implementation=").append(this.implementation);
        }
        if (this.strategy != null) {
            builder.append(", ");
            builder.append("strategy=").append(this.strategy);
        }
        if (this.xRef != null) {
            builder.append(", ");
            builder.append("xRef=").append(this.xRef);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGwtStepDto fromJson(Json json) {
        Builder builder = ImmutableGwtStepDto.builder();
        if (json.sentence != null) {
            builder.sentence(json.sentence);
        }
        if (json.subSteps != null) {
            builder.addAllSubSteps(json.subSteps);
        }
        if (json.implementation != null) {
            builder.implementation(json.implementation);
        }
        if (json.strategy != null) {
            builder.strategy(json.strategy);
        }
        if (json.xRef != null) {
            builder.xRef(json.xRef);
        }
        return builder.build();
    }

    public static ImmutableGwtStepDto copyOf(GwtStepDto instance) {
        if (instance instanceof ImmutableGwtStepDto) {
            return (ImmutableGwtStepDto)instance;
        }
        return ImmutableGwtStepDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sentence;
        private List<GwtStepDto> subSteps = new ArrayList<GwtStepDto>();
        @Nullable
        private GwtStepImplementationDto implementation;
        @Nullable
        private StrategyDto strategy;
        @Nullable
        private String xRef;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GwtStepDto instance) {
            Optional<String> xRefOptional;
            Optional<StrategyDto> strategyOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> sentenceOptional = instance.sentence();
            if (sentenceOptional.isPresent()) {
                this.sentence(sentenceOptional);
            }
            this.addAllSubSteps(instance.subSteps());
            Optional<GwtStepImplementationDto> implementationOptional = instance.implementation();
            if (implementationOptional.isPresent()) {
                this.implementation(implementationOptional);
            }
            if ((strategyOptional = instance.strategy()).isPresent()) {
                this.strategy(strategyOptional);
            }
            if ((xRefOptional = instance.xRef()).isPresent()) {
                this.xRef(xRefOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sentence(String sentence) {
            this.sentence = Objects.requireNonNull(sentence, "sentence");
            return this;
        }

        @JsonProperty(value="sentence")
        @CanIgnoreReturnValue
        public final Builder sentence(Optional<String> sentence) {
            this.sentence = sentence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSubSteps(GwtStepDto element) {
            this.subSteps.add(Objects.requireNonNull(element, "subSteps element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSubSteps(GwtStepDto ... elements) {
            for (GwtStepDto element : elements) {
                this.subSteps.add(Objects.requireNonNull(element, "subSteps element"));
            }
            return this;
        }

        @JsonProperty(value="subSteps")
        @CanIgnoreReturnValue
        public final Builder subSteps(Iterable<? extends GwtStepDto> elements) {
            this.subSteps.clear();
            return this.addAllSubSteps(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSubSteps(Iterable<? extends GwtStepDto> elements) {
            for (GwtStepDto gwtStepDto : elements) {
                this.subSteps.add(Objects.requireNonNull(gwtStepDto, "subSteps element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder implementation(GwtStepImplementationDto implementation) {
            this.implementation = Objects.requireNonNull(implementation, "implementation");
            return this;
        }

        @JsonProperty(value="implementation")
        @CanIgnoreReturnValue
        public final Builder implementation(Optional<? extends GwtStepImplementationDto> implementation) {
            this.implementation = implementation.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder strategy(StrategyDto strategy) {
            this.strategy = Objects.requireNonNull(strategy, "strategy");
            return this;
        }

        @JsonProperty(value="strategy")
        @CanIgnoreReturnValue
        public final Builder strategy(Optional<? extends StrategyDto> strategy) {
            this.strategy = strategy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xRef(String xRef) {
            this.xRef = Objects.requireNonNull(xRef, "xRef");
            return this;
        }

        @JsonProperty(value="x-$ref")
        @CanIgnoreReturnValue
        public final Builder xRef(Optional<String> xRef) {
            this.xRef = xRef.orElse(null);
            return this;
        }

        public ImmutableGwtStepDto build() {
            return new ImmutableGwtStepDto(this.sentence, ImmutableGwtStepDto.createUnmodifiableList(true, this.subSteps), this.implementation, this.strategy, this.xRef);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GwtStepDto {
        @Nullable
        Optional<String> sentence = Optional.empty();
        @Nullable
        List<GwtStepDto> subSteps = Collections.emptyList();
        @Nullable
        Optional<GwtStepImplementationDto> implementation = Optional.empty();
        @Nullable
        Optional<StrategyDto> strategy = Optional.empty();
        @Nullable
        Optional<String> xRef = Optional.empty();

        Json() {
        }

        @JsonProperty(value="sentence")
        public void setSentence(Optional<String> sentence) {
            this.sentence = sentence;
        }

        @JsonProperty(value="subSteps")
        public void setSubSteps(List<GwtStepDto> subSteps) {
            this.subSteps = subSteps;
        }

        @JsonProperty(value="implementation")
        public void setImplementation(Optional<GwtStepImplementationDto> implementation) {
            this.implementation = implementation;
        }

        @JsonProperty(value="strategy")
        public void setStrategy(Optional<StrategyDto> strategy) {
            this.strategy = strategy;
        }

        @JsonProperty(value="x-$ref")
        public void setXRef(Optional<String> xRef) {
            this.xRef = xRef;
        }

        @Override
        public Optional<String> sentence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<GwtStepDto> subSteps() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GwtStepImplementationDto> implementation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<StrategyDto> strategy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> xRef() {
            throw new UnsupportedOperationException();
        }
    }
}

