/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.v2_0;

import com.chutneytesting.design.api.scenario.v2_0.dto.GwtTestCaseDto;
import com.chutneytesting.design.api.scenario.v2_0.dto.RawTestCaseDto;
import com.chutneytesting.design.api.scenario.v2_0.dto.TestCaseIndexDto;
import com.chutneytesting.design.api.scenario.v2_0.mapper.GwtTestCaseMapper;
import com.chutneytesting.design.api.scenario.v2_0.mapper.RawTestCaseMapper;
import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.design.domain.scenario.TestCaseRepository;
import com.chutneytesting.design.domain.scenario.gwt.GwtTestCase;
import com.chutneytesting.execution.api.ExecutionSummaryDto;
import com.chutneytesting.execution.domain.history.ExecutionHistoryRepository;
import com.chutneytesting.security.domain.UserService;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/scenario/v2"})
public class GwtTestCaseController {
    private final TestCaseRepository testCaseRepository;
    private final ExecutionHistoryRepository executionHistoryRepository;
    private final UserService userService;

    public GwtTestCaseController(TestCaseRepository testCaseRepository, ExecutionHistoryRepository executionHistoryRepository, UserService userService) {
        this.testCaseRepository = testCaseRepository;
        this.executionHistoryRepository = executionHistoryRepository;
        this.userService = userService;
    }

    @GetMapping(path={"/{testCaseId}"}, produces={"application/json;charset=UTF-8"})
    public GwtTestCaseDto getTestCase(@PathVariable(value="testCaseId") String testCaseId) {
        return GwtTestCaseMapper.toDto(this.testCaseRepository.findById(testCaseId));
    }

    @GetMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public List<TestCaseIndexDto> getTestCases() {
        List<TestCaseMetadata> testCases = this.testCaseRepository.findAll();
        return testCases.stream().map(tc -> {
            List<ExecutionSummaryDto> executions = ExecutionSummaryDto.toDto(this.executionHistoryRepository.getExecutions(ComposableIdUtils.fromFrontId(Optional.of(tc.id()))));
            return TestCaseIndexDto.from(tc, executions);
        }).collect(Collectors.toList());
    }

    @PostMapping(path={""}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public String saveTestCase(@RequestBody GwtTestCaseDto testCase) {
        return this.saveOrUpdate(testCase);
    }

    @PatchMapping(path={""}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public String updateTestCase(@RequestBody GwtTestCaseDto testCase) {
        return this.saveOrUpdate(testCase);
    }

    private String saveOrUpdate(GwtTestCaseDto testCase) {
        GwtTestCase gwtTestCase = GwtTestCaseMapper.fromDto(testCase);
        return this.gwtTestCaseSave(gwtTestCase);
    }

    @DeleteMapping(path={"/{testCaseId}"})
    public void removeScenarioById(@PathVariable(value="testCaseId") String testCaseId) {
        this.testCaseRepository.removeById(testCaseId);
    }

    @PostMapping(path={"/raw"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public String saveTestCase(@RequestBody RawTestCaseDto rawTestCaseDto) {
        GwtTestCase gwtTestCase = RawTestCaseMapper.fromDto(rawTestCaseDto);
        return this.gwtTestCaseSave(gwtTestCase);
    }

    @GetMapping(path={"/raw/{testCaseId}"}, produces={"application/json;charset=UTF-8"})
    public RawTestCaseDto getTestCaseById(@PathVariable(value="testCaseId") String testCaseId) {
        return RawTestCaseMapper.toDto(this.testCaseRepository.findById(testCaseId));
    }

    private String gwtTestCaseSave(GwtTestCase gwtTestCase) {
        gwtTestCase = GwtTestCase.builder().withMetadata(TestCaseMetadataImpl.TestCaseMetadataBuilder.from(gwtTestCase.metadata).withUpdateDate(Instant.now()).withAuthor(this.userService.getCurrentUser().getId()).build()).withScenario(gwtTestCase.scenario).withDataSet(gwtTestCase.dataSet).build();
        return this.testCaseRepository.save(gwtTestCase);
    }
}

