/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.compose.mapper;

import com.chutneytesting.design.api.scenario.compose.dto.ComposableStepDto;
import com.chutneytesting.design.api.scenario.compose.dto.ComposableTestCaseDto;
import com.chutneytesting.design.api.scenario.compose.dto.ImmutableComposableScenarioDto;
import com.chutneytesting.design.api.scenario.compose.dto.ImmutableComposableTestCaseDto;
import com.chutneytesting.design.api.scenario.compose.mapper.ComposableStepMapper;
import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.design.domain.scenario.compose.ComposableScenario;
import com.chutneytesting.design.domain.scenario.compose.ComposableTestCase;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import com.chutneytesting.tools.ui.KeyValue;
import java.util.List;
import java.util.stream.Collectors;

public class ComposableTestCaseMapper {
    public static ComposableTestCase fromDto(ComposableTestCaseDto composableTestCaseDto) {
        return new ComposableTestCase(ComposableIdUtils.fromFrontId(composableTestCaseDto.id()), ComposableTestCaseMapper.testCaseMetadataFromDto(composableTestCaseDto), ComposableTestCaseMapper.fromComposableStepsDto(composableTestCaseDto));
    }

    public static ComposableTestCaseDto toDto(ComposableTestCase composableTestCase) {
        return ImmutableComposableTestCaseDto.builder().id(ComposableIdUtils.toFrontId(composableTestCase.id)).title(composableTestCase.metadata.title()).description(composableTestCase.metadata.description()).creationDate(composableTestCase.metadata.creationDate()).computedParameters(KeyValue.fromMap(composableTestCase.computedParameters)).scenario(ImmutableComposableScenarioDto.builder().addAllComponentSteps(ComposableTestCaseMapper.toComposableStepsDto(composableTestCase)).addAllParameters(KeyValue.fromMap(composableTestCase.composableScenario.parameters)).build()).tags(composableTestCase.metadata.tags()).datasetId(ComposableIdUtils.toFrontId(composableTestCase.metadata.datasetId().orElse(""))).author(composableTestCase.metadata.author()).updateDate(composableTestCase.metadata.updateDate()).version(composableTestCase.metadata.version()).build();
    }

    private static TestCaseMetadata testCaseMetadataFromDto(ComposableTestCaseDto composableTestCaseDto) {
        return TestCaseMetadataImpl.builder().withTitle(composableTestCaseDto.title()).withDescription(composableTestCaseDto.description().orElse("")).withCreationDate(composableTestCaseDto.creationDate()).withRepositorySource("ComposableTestCase").withTags(composableTestCaseDto.tags()).withDatasetId(ComposableIdUtils.fromFrontId(composableTestCaseDto.datasetId())).withAuthor(composableTestCaseDto.author()).withUpdateDate(composableTestCaseDto.updateDate()).withVersion(composableTestCaseDto.version()).build();
    }

    private static ComposableScenario fromComposableStepsDto(ComposableTestCaseDto composableTestCaseDto) {
        return ComposableScenario.builder().withComposableSteps(composableTestCaseDto.scenario().componentSteps().stream().map(ComposableStepMapper::fromDto).collect(Collectors.toList())).withParameters(KeyValue.toMap(composableTestCaseDto.scenario().parameters())).build();
    }

    private static List<ComposableStepDto> toComposableStepsDto(ComposableTestCase composableTestCase) {
        return composableTestCase.composableScenario.composableSteps.stream().map(ComposableStepMapper::toDto).collect(Collectors.toList());
    }
}

