/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.compose.mapper;

import com.chutneytesting.design.api.scenario.compose.dto.ComposableStepDto;
import com.chutneytesting.design.api.scenario.compose.dto.ImmutableComposableStepDto;
import com.chutneytesting.design.api.scenario.compose.dto.ImmutableStrategy;
import com.chutneytesting.design.api.scenario.compose.dto.Strategy;
import com.chutneytesting.design.domain.scenario.compose.ComposableStep;
import com.chutneytesting.design.domain.scenario.compose.StepUsage;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import com.chutneytesting.tools.ui.KeyValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposableStepMapper {
    public static ComposableStepDto toDto(ComposableStep composableStep) {
        ImmutableComposableStepDto.Builder builder = ImmutableComposableStepDto.builder().id(ComposableIdUtils.toFrontId(composableStep.id)).name(composableStep.name).tags(composableStep.tags);
        composableStep.usage.ifPresent(stepUsage -> builder.usage(ComposableStepDto.StepUsage.valueOf(stepUsage.name())));
        composableStep.implementation.ifPresent(builder::task);
        composableStep.steps.forEach(step -> builder.addSteps(ComposableStepMapper.toDto(step)));
        builder.parameters(KeyValue.fromMap(composableStep.parameters));
        builder.strategy(ComposableStepMapper.toDto(composableStep.strategy));
        builder.addAllComputedParameters(KeyValue.fromMap(composableStep.dataSet));
        return builder.build();
    }

    private static Strategy toDto(com.chutneytesting.design.domain.scenario.compose.Strategy strategy) {
        return ImmutableStrategy.builder().type(ComposableStrategyType.fromEngineType((String)strategy.type).name).putAllParameters(ComposableStepMapper.toDto(strategy.parameters)).build();
    }

    private static Map<String, Object> toDto(Map<String, Object> parameters) {
        HashMap<String, Object> parametersDto = new HashMap<String, Object>(parameters);
        if (parametersDto.containsKey("timeOut")) {
            parametersDto.put("timeout", parameters.get("timeOut"));
            parametersDto.remove("timeOut");
        }
        if (parametersDto.containsKey("retryDelay")) {
            parametersDto.put("delay", parameters.get("retryDelay"));
            parametersDto.remove("retryDelay");
        }
        return parametersDto;
    }

    public static ComposableStep fromDto(ComposableStepDto dto) {
        ComposableStep.ComposableStepBuilder composableStepBuilder = ComposableStep.builder().withId(ComposableIdUtils.fromFrontId(dto.id())).withName(dto.name()).withUsage(Optional.of(StepUsage.valueOf(dto.usage().name()))).withStrategy(ComposableStepMapper.fromDto(dto.strategy())).withImplementation(dto.task()).withSteps(dto.steps().stream().map(ComposableStepMapper::fromDto).collect(Collectors.toList())).withParameters(KeyValue.toMap(dto.parameters())).overrideDataSetWith(KeyValue.toMap(dto.computedParameters())).withTags(dto.tags().stream().map(String::trim).filter(t -> !t.isEmpty()).collect(Collectors.toList()));
        return composableStepBuilder.build();
    }

    private static com.chutneytesting.design.domain.scenario.compose.Strategy fromDto(Strategy strategyDto) {
        return new com.chutneytesting.design.domain.scenario.compose.Strategy(ComposableStrategyType.fromName((String)strategyDto.type()).engineType, ComposableStepMapper.fromDto(strategyDto.parameters()));
    }

    private static Map<String, Object> fromDto(Map<String, Object> parametersDto) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(parametersDto);
        if (parameters.containsKey("timeout")) {
            parameters.put("timeOut", parametersDto.get("timeout"));
            parameters.remove("timeout");
        }
        if (parameters.containsKey("delay")) {
            parameters.put("retryDelay", parametersDto.get("delay"));
            parameters.remove("delay");
        }
        return parameters;
    }

    private static enum ComposableStrategyType {
        DEFAULT("Default", ""),
        RETRY("Retry", "retry-with-timeout"),
        SOFT("Soft", "soft-assert"),
        Loop("Loop", "Loop");

        private static final Logger LOGGER;
        public final String name;
        public final String engineType;

        private ComposableStrategyType(String name, String engineType) {
            this.name = name;
            this.engineType = engineType;
        }

        public static ComposableStrategyType fromName(String name) {
            for (ComposableStrategyType e : ComposableStrategyType.values()) {
                if (!e.name.equals(name)) continue;
                return e;
            }
            LOGGER.warn("Mapping strategy [{}] for engine as default", (Object)name);
            return DEFAULT;
        }

        public static ComposableStrategyType fromEngineType(String engineType) {
            for (ComposableStrategyType e : ComposableStrategyType.values()) {
                if (!e.engineType.equals(engineType)) continue;
                return e;
            }
            LOGGER.warn("Mapping strategy [{}] for UI as default", (Object)engineType);
            return DEFAULT;
        }

        static {
            LOGGER = LoggerFactory.getLogger(ComposableStrategyType.class);
        }
    }
}

