/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.compose.dto;

import com.chutneytesting.design.api.scenario.compose.dto.Strategy;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableStrategy
implements Strategy {
    private final String type;
    private final Map<String, Object> parameters;

    private ImmutableStrategy(Builder builder) {
        this.parameters = ImmutableStrategy.createUnmodifiableMap(false, false, builder.parameters);
        this.type = builder.type != null ? builder.type : Objects.requireNonNull(Strategy.super.type(), "type");
    }

    private ImmutableStrategy(String type, Map<String, Object> parameters) {
        this.type = type;
        this.parameters = parameters;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="parameters")
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public final ImmutableStrategy withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "type");
        return new ImmutableStrategy(newValue, this.parameters);
    }

    public final ImmutableStrategy withParameters(Map<String, ? extends Object> entries) {
        if (this.parameters == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableStrategy.createUnmodifiableMap(true, false, entries);
        return new ImmutableStrategy(this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStrategy && this.equalTo((ImmutableStrategy)another);
    }

    private boolean equalTo(ImmutableStrategy another) {
        return this.type.equals(another.type) && this.parameters.equals(another.parameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.parameters.hashCode();
        return h;
    }

    public String toString() {
        return "Strategy{type=" + this.type + ", parameters=" + this.parameters + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStrategy fromJson(Json json) {
        Builder builder = ImmutableStrategy.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.parameters != null) {
            builder.putAllParameters(json.parameters);
        }
        return builder.build();
    }

    public static ImmutableStrategy copyOf(Strategy instance) {
        if (instance instanceof ImmutableStrategy) {
            return (ImmutableStrategy)instance;
        }
        return ImmutableStrategy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String type;
        private Map<String, Object> parameters = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Strategy instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.putAllParameters(instance.parameters());
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putParameters(String key, Object value) {
            this.parameters.put(Objects.requireNonNull(key, "parameters key"), Objects.requireNonNull(value, "parameters value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putParameters(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            return this;
        }

        @JsonProperty(value="parameters")
        @CanIgnoreReturnValue
        public final Builder parameters(Map<String, ? extends Object> parameters) {
            this.parameters.clear();
            return this.putAllParameters(parameters);
        }

        @CanIgnoreReturnValue
        public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
            for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            }
            return this;
        }

        public ImmutableStrategy build() {
            return new ImmutableStrategy(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Strategy {
        @Nullable
        String type;
        @Nullable
        Map<String, Object> parameters = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="parameters")
        public void setParameters(Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> parameters() {
            throw new UnsupportedOperationException();
        }
    }
}

