/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.compose.dto;

import com.chutneytesting.design.api.scenario.compose.dto.ParentsStepDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableNameIdDto
implements ParentsStepDto.NameIdDto {
    private final String id;
    private final String name;

    private ImmutableNameIdDto(String id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    public final ImmutableNameIdDto withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "id");
        return new ImmutableNameIdDto(newValue, this.name);
    }

    public final ImmutableNameIdDto withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "name");
        return new ImmutableNameIdDto(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNameIdDto && this.equalTo((ImmutableNameIdDto)another);
    }

    private boolean equalTo(ImmutableNameIdDto another) {
        return this.id.equals(another.id) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "NameIdDto{id=" + this.id + ", name=" + this.name + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNameIdDto fromJson(Json json) {
        Builder builder = ImmutableNameIdDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    public static ImmutableNameIdDto copyOf(ParentsStepDto.NameIdDto instance) {
        if (instance instanceof ImmutableNameIdDto) {
            return (ImmutableNameIdDto)instance;
        }
        return ImmutableNameIdDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParentsStepDto.NameIdDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableNameIdDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNameIdDto(this.id, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build NameIdDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ParentsStepDto.NameIdDto {
        @Nullable
        String id;
        @Nullable
        String name;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }
    }
}

