/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.compose.dto;

import com.chutneytesting.design.api.scenario.compose.dto.ComposableStepDto;
import com.chutneytesting.design.api.scenario.compose.dto.ImmutableComposableScenarioDto;
import com.chutneytesting.design.api.scenario.compose.dto.ImmutableComposableTestCaseDto;
import com.chutneytesting.security.domain.User;
import com.chutneytesting.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableComposableTestCaseDto.class)
@JsonDeserialize(as=ImmutableComposableTestCaseDto.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@Value.Style(jdkOnly=true)
public interface ComposableTestCaseDto {
    public Optional<String> id();

    public String title();

    public Optional<String> description();

    @Value.Default
    default public Instant creationDate() {
        return Instant.now();
    }

    public List<String> tags();

    public ComposableScenarioDto scenario();

    public Optional<String> datasetId();

    @Value.Default
    default public String author() {
        return User.ANONYMOUS_USER.getId();
    }

    @Value.Default
    default public Instant updateDate() {
        return Instant.now();
    }

    @Value.Default
    default public Integer version() {
        return 1;
    }

    @Value.Default
    default public List<KeyValue> computedParameters() {
        return Collections.emptyList();
    }

    @JsonSerialize(as=ImmutableComposableScenarioDto.class)
    @JsonDeserialize(as=ImmutableComposableScenarioDto.class)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Value.Immutable
    @Value.Style(jdkOnly=true)
    public static interface ComposableScenarioDto {
        @Value.Default
        default public List<KeyValue> parameters() {
            return Collections.emptyList();
        }

        @Value.Default
        default public List<ComposableStepDto> componentSteps() {
            return Collections.emptyList();
        }
    }
}

