/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.compose;

import com.chutneytesting.design.api.scenario.compose.dto.ComposableStepDto;
import com.chutneytesting.design.api.scenario.compose.dto.ParentsStepDto;
import com.chutneytesting.design.api.scenario.compose.mapper.ComposableStepMapper;
import com.chutneytesting.design.api.scenario.compose.mapper.ParentStepMapper;
import com.chutneytesting.design.domain.scenario.compose.ComposableStep;
import com.chutneytesting.design.domain.scenario.compose.ComposableStepRepository;
import com.chutneytesting.design.domain.scenario.compose.StepUsage;
import com.chutneytesting.tools.ImmutablePaginatedDto;
import com.chutneytesting.tools.ImmutablePaginationRequestParametersDto;
import com.chutneytesting.tools.ImmutableSortRequestParametersDto;
import com.chutneytesting.tools.PaginatedDto;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/steps/v1"})
@CrossOrigin(origins={"*"})
public class StepController {
    static final String BASE_URL = "/api/steps/v1";
    private final ComposableStepRepository composableStepRepository;
    static final String FIND_STEPS_NAME_DEFAULT_VALUE = "";
    static final String FIND_STEPS_USAGE_DEFAULT_VALUE = "";
    static final String FIND_STEPS_START_DEFAULT_VALUE = "1";
    static final String FIND_STEPS_LIMIT_DEFAULT_VALUE = "25";

    public StepController(ComposableStepRepository composableStepRepository) {
        this.composableStepRepository = composableStepRepository;
    }

    @PostMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public String save(@RequestBody ComposableStepDto step) {
        return ComposableIdUtils.toFrontId(this.composableStepRepository.save(ComposableStepMapper.fromDto(step)));
    }

    @DeleteMapping(path={"/{stepId}"})
    public void deleteById(@PathVariable String stepId) {
        this.composableStepRepository.deleteById(ComposableIdUtils.fromFrontId(stepId));
    }

    @GetMapping(path={"/all"}, produces={"application/json;charset=UTF-8"})
    public List<ComposableStepDto> findAll() {
        return this.composableStepRepository.findAll().stream().map(ComposableStepMapper::toDto).sorted(ComposableStepDto.stepDtoComparator).collect(Collectors.toList());
    }

    @GetMapping(path={"/{stepId}/parents"}, produces={"application/json;charset=UTF-8"})
    public ParentsStepDto findParents(@PathVariable String stepId) {
        return ParentStepMapper.toDto(this.composableStepRepository.findParents(ComposableIdUtils.fromFrontId(stepId)));
    }

    @GetMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public PaginatedDto<ComposableStepDto> findSteps(@RequestParam(defaultValue="") String name, @RequestParam(defaultValue="") String usage, @RequestParam(defaultValue="1") Long start, @RequestParam(defaultValue="25") Long limit, @RequestParam(required=false) String sort, @RequestParam(required=false) String desc) {
        PaginatedDto<ComposableStep> composableStepsPaginatedDto = this.composableStepRepository.find(ImmutablePaginationRequestParametersDto.builder().start(start).limit(limit).build(), ImmutableSortRequestParametersDto.builder().sort(sort).desc(desc).build(), ComposableStep.builder().withName(name).withUsage(StepUsage.fromName(usage)).withSteps(Collections.emptyList()).build());
        return ImmutablePaginatedDto.builder().totalCount(composableStepsPaginatedDto.totalCount()).addAllData(composableStepsPaginatedDto.data().stream().map(ComposableStepMapper::toDto).collect(Collectors.toList())).build();
    }

    @GetMapping(path={"/{stepId}"}, produces={"application/json;charset=UTF-8"})
    public ComposableStepDto findById(@PathVariable String stepId) {
        return ComposableStepMapper.toDto(this.composableStepRepository.findById(ComposableIdUtils.fromFrontId(stepId)));
    }
}

