/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario.compose;

import com.chutneytesting.design.api.scenario.compose.dto.ComposableTestCaseDto;
import com.chutneytesting.design.api.scenario.compose.mapper.ComposableTestCaseMapper;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.design.domain.scenario.TestCaseRepository;
import com.chutneytesting.design.domain.scenario.compose.ComposableTestCase;
import com.chutneytesting.design.domain.scenario.compose.ComposableTestCaseRepository;
import com.chutneytesting.security.domain.UserService;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import java.time.Instant;
import java.util.Optional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/scenario/component-edition"})
public class ComponentEditionController {
    static final String BASE_URL = "/api/scenario/component-edition";
    private final ComposableTestCaseRepository composableTestCaseRepository;
    private final TestCaseRepository testCaseRepository;
    private final UserService userService;

    public ComponentEditionController(ComposableTestCaseRepository composableTestCaseRepository, TestCaseRepository testCaseRepository, UserService userService) {
        this.composableTestCaseRepository = composableTestCaseRepository;
        this.testCaseRepository = testCaseRepository;
        this.userService = userService;
    }

    @PostMapping(path={""}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public String saveTestCase(@RequestBody ComposableTestCaseDto composableTestCaseDto) {
        ComposableTestCase composableTestCase = ComposableTestCaseMapper.fromDto(composableTestCaseDto);
        composableTestCase = new ComposableTestCase(composableTestCase.id, TestCaseMetadataImpl.TestCaseMetadataBuilder.from(composableTestCase.metadata).withUpdateDate(Instant.now()).withAuthor(this.userService.getCurrentUser().getId()).build(), composableTestCase.composableScenario);
        return ComposableIdUtils.toFrontId(this.composableTestCaseRepository.save(composableTestCase));
    }

    @GetMapping(path={"/{testCaseId}"}, produces={"application/json;charset=UTF-8"})
    public ComposableTestCaseDto getTestCase(@PathVariable(value="testCaseId") String testCaseId) {
        return ComposableTestCaseMapper.toDto(this.composableTestCaseRepository.findById(ComposableIdUtils.fromFrontId(Optional.of(testCaseId))));
    }

    @DeleteMapping(path={"/{testCaseId}"})
    public void removeScenarioById(@PathVariable(value="testCaseId") String testCaseId) {
        String testCaseBackId = ComposableIdUtils.fromFrontId(Optional.of(testCaseId));
        this.testCaseRepository.removeById(testCaseBackId);
        this.composableTestCaseRepository.removeById(testCaseBackId);
    }
}

