/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.scenario;

import com.chutneytesting.design.api.scenario.v2_0.mapper.GwtScenarioMapper;
import com.chutneytesting.design.domain.scenario.ScenarioNotParsableException;
import com.chutneytesting.design.domain.scenario.gwt.GwtScenario;
import com.chutneytesting.design.domain.scenario.gwt.GwtStep;
import com.chutneytesting.design.domain.scenario.gwt.GwtStepImplementation;
import com.chutneytesting.design.domain.scenario.gwt.Strategy;
import com.chutneytesting.execution.domain.compiler.ScenarioConversionException;
import com.chutneytesting.tools.Streams;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hjson.JsonValue;

public class OldFormatAdapter {
    public static GwtScenario from(String title, String description, String jsonScenario) {
        return OldFormatAdapter.fromV0(jsonScenario).toGwt(title, description);
    }

    static Convertible fromV0(String jsonScenario) {
        try {
            return (Convertible)GwtScenarioMapper.mapper.readValue(jsonScenario, ScenarioV0.class);
        }
        catch (IOException e) {
            return OldFormatAdapter.fromV1(jsonScenario);
        }
    }

    static Convertible fromV1(String jsonScenario) {
        try {
            return (Convertible)GwtScenarioMapper.mapper.readValue(jsonScenario, ScenarioV1.class);
        }
        catch (IOException e) {
            return OldFormatAdapter.fromV2_0(jsonScenario);
        }
    }

    static Convertible fromV2_0(String jsonScenario) {
        try {
            return (Convertible)GwtScenarioMapper.mapper.readValue(jsonScenario, ScenarioV2_0.class);
        }
        catch (IOException e) {
            throw new ScenarioNotParsableException("Cannot deserialize scenario: ", e);
        }
    }

    static class ScenarioV2_0
    implements Convertible {
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        String title = "";
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        String description = "";
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        List<GwtStep2_0> givens = Collections.emptyList();
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        GwtStep2_0 when;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        List<GwtStep2_0> thens = Collections.emptyList();

        ScenarioV2_0() {
        }

        @Override
        public GwtScenario toGwt(String title, String description) {
            return GwtScenario.builder().withTitle(title).withDescription(description).withGivens(this.givens.stream().map(GwtStep2_0::toGwt).collect(Collectors.toList())).withWhen(this.when.toGwt()).withThens(this.thens.stream().map(GwtStep2_0::toGwt).collect(Collectors.toList())).build();
        }

        static class GwtStepImplementationV2_0 {
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            String task = "";

            GwtStepImplementationV2_0() {
            }

            GwtStepImplementation toGwt() {
                try {
                    return (GwtStepImplementation)GwtScenarioMapper.mapper.readValue(JsonValue.readHjson((String)this.task).toString(), GwtStepImplementation.class);
                }
                catch (IOException e) {
                    throw new ScenarioConversionException(e);
                }
            }
        }

        static class GwtStep2_0 {
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            String description = "";
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            List<GwtStep2_0> subSteps = Collections.emptyList();
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            Optional<GwtStepImplementationV2_0> implementation = Optional.empty();
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            Optional<Strategy> strategy = Optional.empty();

            GwtStep2_0() {
            }

            GwtStep toGwt() {
                GwtStep.GwtStepBuilder builder = GwtStep.builder().withDescription(this.description).withSubSteps(this.subSteps.stream().map(GwtStep2_0::toGwt).collect(Collectors.toList()));
                this.strategy.ifPresent(builder::withStrategy);
                this.implementation.ifPresent(i -> builder.withImplementation(i.toGwt()));
                return builder.build();
            }
        }
    }

    static class ScenarioV1
    implements Convertible {
        @JsonProperty(value="scenario")
        StepV1 rootStep = StepV1.NONE;

        ScenarioV1() {
        }

        @Override
        public GwtScenario toGwt(String title, String description) {
            StepV1 lastWhen = Streams.findLast(this.rootStep.steps.stream(), s -> s.gwtType != null && s.gwtType.equals((Object)StepV1.GwtType.WHEN)).orElse(StepV1.NONE);
            return GwtScenario.builder().withTitle(title).withDescription(description).withGivens(Streams.takeUntil(this.rootStep.steps.stream(), s -> s.equals(lastWhen)).map(StepV1::toGwt).collect(Collectors.toList())).withWhen(Optional.of(lastWhen).map(StepV1::toGwt).orElse(GwtStep.NONE)).withThens(Streams.skipUntil(this.rootStep.steps.stream(), s -> s.equals(lastWhen)).map(StepV1::toGwt).collect(Collectors.toList())).build();
        }

        static class StepStrategyV1 {
            static StepStrategyV1 NONE = new StepStrategyV1();
            public String type = "";
            public Map<String, Object> parameters = Collections.emptyMap();

            StepStrategyV1() {
            }
        }

        static class StepV1 {
            static StepV1 NONE = new StepV1();
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY, required=true)
            GwtType gwtType;
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            String name = "";
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            List<StepV1> steps = Collections.emptyList();
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            StepStrategyV1 strategy = StepStrategyV1.NONE;
            public String type;
            public String target;
            public Map<String, Object> inputs;
            public Map<String, Object> outputs;

            StepV1() {
            }

            GwtStep toGwt() {
                GwtStep.GwtStepBuilder builder = GwtStep.builder().withDescription(this.name).withSubSteps(this.steps.stream().map(StepV1::toGwt).collect(Collectors.toList()));
                if (this.type != null && !this.type.isEmpty()) {
                    builder.withImplementation(new GwtStepImplementation(this.type, this.target, this.inputs, this.outputs, ""));
                }
                if (!this.strategy.equals(StepStrategyV1.NONE)) {
                    builder.withStrategy(new Strategy(this.strategy.type, this.strategy.parameters));
                }
                return builder.build();
            }

            static enum GwtType {
                ROOT_STEP,
                GIVEN,
                WHEN,
                THEN;

            }
        }
    }

    static class ScenarioV0
    implements Convertible {
        @JsonProperty(value="scenario")
        StepV0 rootStep = StepV0.NONE;

        ScenarioV0() {
        }

        @Override
        public GwtScenario toGwt(String title, String description) {
            return GwtScenario.builder().withTitle(title).withDescription(description).withGivens(this.rootStep.steps.stream().map(StepV0::toGwt).collect(Collectors.toList())).withWhen(GwtStep.NONE).withThens(Collections.singletonList(GwtStep.NONE)).build();
        }

        static class StepStrategyV0 {
            static StepStrategyV0 NONE = new StepStrategyV0();
            public String type = "";
            public Map<String, Object> parameters = Collections.emptyMap();

            StepStrategyV0() {
            }
        }

        static class StepV0 {
            static StepV0 NONE = new StepV0();
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            String name = "";
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            List<StepV0> steps = Collections.emptyList();
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            StepStrategyV0 strategy = StepStrategyV0.NONE;
            public String type;
            public String target;
            public Map<String, Object> inputs;
            public Map<String, Object> outputs;

            StepV0() {
            }

            GwtStep toGwt() {
                GwtStep.GwtStepBuilder builder = GwtStep.builder().withDescription(this.name).withSubSteps(this.steps.stream().map(StepV0::toGwt).collect(Collectors.toList()));
                if (this.type != null && !this.type.isEmpty()) {
                    builder.withImplementation(new GwtStepImplementation(this.type, this.target, this.inputs, this.outputs, ""));
                }
                if (!this.strategy.equals(StepStrategyV0.NONE)) {
                    builder.withStrategy(new Strategy(this.strategy.type, this.strategy.parameters));
                }
                return builder.build();
            }
        }
    }

    static interface Convertible {
        public GwtScenario toGwt(String var1, String var2);
    }
}

