/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.plugins.jira;

import com.chutneytesting.design.api.plugins.jira.ImmutableJiraConfigurationDto;
import com.chutneytesting.design.api.plugins.jira.ImmutableJiraDto;
import com.chutneytesting.design.api.plugins.jira.JiraConfigurationDto;
import com.chutneytesting.design.api.plugins.jira.JiraDto;
import com.chutneytesting.design.domain.plugins.jira.JiraRepository;
import com.chutneytesting.design.domain.plugins.jira.JiraTargetConfiguration;
import com.chutneytesting.execution.domain.jira.JiraXrayPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/jira/v1/"})
@CrossOrigin(origins={"*"})
public class JiraModuleController {
    public static final String BASE_URL = "/api/ui/jira/v1/";
    public static final String BASE_SCENARIO_URL = "scenario";
    public static final String BASE_CAMPAIGN_URL = "campaign";
    public static final String BASE_TEST_EXEC_URL = "testexec";
    public static final String BASE_CONFIGURATION_URL = "configuration";
    private final JiraRepository jiraRepository;
    private final JiraXrayPlugin jiraXrayPlugin;

    public JiraModuleController(JiraRepository jiraRepository, JiraXrayPlugin jiraXrayPlugin) {
        this.jiraRepository = jiraRepository;
        this.jiraXrayPlugin = jiraXrayPlugin;
    }

    @GetMapping(path={"scenario"}, produces={"application/json;charset=UTF-8"})
    public Map<String, String> getLinkedScenarios() {
        return this.jiraRepository.getAllLinkedScenarios();
    }

    @GetMapping(path={"campaign"}, produces={"application/json;charset=UTF-8"})
    public Map<String, String> getLinkedCampaigns() {
        return this.jiraRepository.getAllLinkedCampaigns();
    }

    @GetMapping(path={"scenario/{scenarioId}"}, produces={"application/json;charset=UTF-8"})
    public JiraDto getByScenarioId(@PathVariable String scenarioId) {
        String jiraId = this.jiraRepository.getByScenarioId(scenarioId);
        return ImmutableJiraDto.builder().id(jiraId).chutneyId(scenarioId).build();
    }

    @PostMapping(path={"scenario"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public JiraDto saveForScenario(@RequestBody JiraDto jiraDto) {
        this.jiraRepository.saveForScenario(jiraDto.chutneyId(), jiraDto.id());
        return ImmutableJiraDto.builder().id(jiraDto.id()).chutneyId(jiraDto.chutneyId()).build();
    }

    @DeleteMapping(path={"scenario/{scenarioId}"})
    public void removeForScenario(@PathVariable String scenarioId) {
        this.jiraRepository.removeForScenario(scenarioId);
    }

    @GetMapping(path={"campaign/{campaignId}"}, produces={"application/json;charset=UTF-8"})
    public JiraDto getByCampaignId(@PathVariable String campaignId) {
        String jiraId = this.jiraRepository.getByCampaignId(campaignId);
        return ImmutableJiraDto.builder().id(jiraId).chutneyId(campaignId).build();
    }

    @GetMapping(path={"testexec/{testExecId}"}, produces={"application/json;charset=UTF-8"})
    public List<String> getScenariosByCampaignIg(@PathVariable String testExecId) {
        if (testExecId.isEmpty()) {
            return new ArrayList<String>();
        }
        Map<String, String> allLinkedScenarios = this.jiraRepository.getAllLinkedScenarios();
        List<String> testExecScenariosId = this.jiraXrayPlugin.getTestExecutionScenarios(testExecId);
        return allLinkedScenarios.entrySet().stream().filter(entry -> testExecScenariosId.contains(entry.getValue())).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
    }

    @PostMapping(path={"campaign"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public JiraDto saveForCampaign(@RequestBody JiraDto jiraDto) {
        this.jiraRepository.saveForCampaign(jiraDto.chutneyId(), jiraDto.id());
        return ImmutableJiraDto.builder().id(jiraDto.id()).chutneyId(jiraDto.chutneyId()).build();
    }

    @DeleteMapping(path={"campaign/{campaignId}"})
    public void removeForCampaign(@PathVariable String campaignId) {
        this.jiraRepository.removeForCampaign(campaignId);
    }

    @GetMapping(path={"configuration"}, produces={"application/json;charset=UTF-8"})
    public JiraConfigurationDto getConfiguration() {
        JiraTargetConfiguration jiraTargetConfiguration = this.jiraRepository.loadServerConfiguration();
        return ImmutableJiraConfigurationDto.builder().url(jiraTargetConfiguration.url).username(jiraTargetConfiguration.username).password(jiraTargetConfiguration.password).build();
    }

    @PostMapping(path={"configuration"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public void saveConfiguration(@RequestBody JiraConfigurationDto jiraConfigurationDto) {
        this.jiraRepository.saveServerConfiguration(new JiraTargetConfiguration(jiraConfigurationDto.url(), jiraConfigurationDto.username(), jiraConfigurationDto.password()));
    }
}

