/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.plugins.jira;

import com.chutneytesting.design.api.plugins.jira.JiraDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableJiraDto
implements JiraDto {
    private final String id;
    private final String chutneyId;

    private ImmutableJiraDto(String id, String chutneyId) {
        this.id = id;
        this.chutneyId = chutneyId;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="chutneyId")
    public String chutneyId() {
        return this.chutneyId;
    }

    public final ImmutableJiraDto withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "id");
        return new ImmutableJiraDto(newValue, this.chutneyId);
    }

    public final ImmutableJiraDto withChutneyId(String value) {
        if (this.chutneyId.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "chutneyId");
        return new ImmutableJiraDto(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJiraDto && this.equalTo((ImmutableJiraDto)another);
    }

    private boolean equalTo(ImmutableJiraDto another) {
        return this.id.equals(another.id) && this.chutneyId.equals(another.chutneyId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.chutneyId.hashCode();
        return h;
    }

    public String toString() {
        return "JiraDto{id=" + this.id + ", chutneyId=" + this.chutneyId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJiraDto fromJson(Json json) {
        Builder builder = ImmutableJiraDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.chutneyId != null) {
            builder.chutneyId(json.chutneyId);
        }
        return builder.build();
    }

    public static ImmutableJiraDto copyOf(JiraDto instance) {
        if (instance instanceof ImmutableJiraDto) {
            return (ImmutableJiraDto)instance;
        }
        return ImmutableJiraDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CHUTNEY_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String chutneyId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JiraDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.chutneyId(instance.chutneyId());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="chutneyId")
        @CanIgnoreReturnValue
        public final Builder chutneyId(String chutneyId) {
            this.chutneyId = Objects.requireNonNull(chutneyId, "chutneyId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableJiraDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJiraDto(this.id, this.chutneyId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("chutneyId");
            }
            return "Cannot build JiraDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements JiraDto {
        @Nullable
        String id;
        @Nullable
        String chutneyId;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="chutneyId")
        public void setChutneyId(String chutneyId) {
            this.chutneyId = chutneyId;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String chutneyId() {
            throw new UnsupportedOperationException();
        }
    }
}

