/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.plugins.jira;

import com.chutneytesting.design.api.plugins.jira.JiraConfigurationDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableJiraConfigurationDto
implements JiraConfigurationDto {
    private final String url;
    private final String username;
    private final String password;

    private ImmutableJiraConfigurationDto(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    @Override
    @JsonProperty(value="url")
    public String url() {
        return this.url;
    }

    @Override
    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="password")
    public String password() {
        return this.password;
    }

    public final ImmutableJiraConfigurationDto withUrl(String value) {
        if (this.url.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "url");
        return new ImmutableJiraConfigurationDto(newValue, this.username, this.password);
    }

    public final ImmutableJiraConfigurationDto withUsername(String value) {
        if (this.username.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "username");
        return new ImmutableJiraConfigurationDto(this.url, newValue, this.password);
    }

    public final ImmutableJiraConfigurationDto withPassword(String value) {
        if (this.password.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "password");
        return new ImmutableJiraConfigurationDto(this.url, this.username, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJiraConfigurationDto && this.equalTo((ImmutableJiraConfigurationDto)another);
    }

    private boolean equalTo(ImmutableJiraConfigurationDto another) {
        return this.url.equals(another.url) && this.username.equals(another.username) && this.password.equals(another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.password.hashCode();
        return h;
    }

    public String toString() {
        return "JiraConfigurationDto{url=" + this.url + ", username=" + this.username + ", password=" + this.password + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJiraConfigurationDto fromJson(Json json) {
        Builder builder = ImmutableJiraConfigurationDto.builder();
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.password != null) {
            builder.password(json.password);
        }
        return builder.build();
    }

    public static ImmutableJiraConfigurationDto copyOf(JiraConfigurationDto instance) {
        if (instance instanceof ImmutableJiraConfigurationDto) {
            return (ImmutableJiraConfigurationDto)instance;
        }
        return ImmutableJiraConfigurationDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_USERNAME = 2L;
        private static final long INIT_BIT_PASSWORD = 4L;
        private long initBits = 7L;
        @Nullable
        private String url;
        @Nullable
        private String username;
        @Nullable
        private String password;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JiraConfigurationDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.url(instance.url());
            this.username(instance.username());
            this.password(instance.password());
            return this;
        }

        @JsonProperty(value="url")
        @CanIgnoreReturnValue
        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="username")
        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="password")
        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableJiraConfigurationDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJiraConfigurationDto(this.url, this.username, this.password);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build JiraConfigurationDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements JiraConfigurationDto {
        @Nullable
        String url;
        @Nullable
        String username;
        @Nullable
        String password;

        Json() {
        }

        @JsonProperty(value="url")
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="password")
        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public String url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String password() {
            throw new UnsupportedOperationException();
        }
    }
}

