/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.globalvar;

import com.chutneytesting.design.domain.globalvar.GlobalvarRepository;
import com.chutneytesting.design.infra.storage.globalvar.FileGlobalVarRepository;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import org.hjson.JsonValue;
import org.hjson.Stringify;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/globalvar/v1"})
public class GlobalVarController {
    private final GlobalvarRepository globalVarRepository;

    public GlobalVarController(FileGlobalVarRepository globalVarRepository) {
        this.globalVarRepository = globalVarRepository;
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public Set<String> list() {
        return this.globalVarRepository.list();
    }

    @CrossOrigin(origins={"*"})
    @PostMapping(path={"/{fileName}"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public void save(@PathVariable(value="fileName") String fileName, @RequestBody TextDto textContent) {
        try {
            this.globalVarRepository.saveFile(fileName, JsonValue.readHjson((String)textContent.getMessage()).toString(Stringify.HJSON));
        }
        catch (Exception e) {
            throw new RuntimeException("Not valid hjson", e);
        }
    }

    @CrossOrigin(origins={"*"})
    @DeleteMapping(path={"/{fileName}"})
    public void delete(@PathVariable(value="fileName") String fileName) {
        this.globalVarRepository.deleteFile(fileName);
    }

    @CrossOrigin(origins={"*"})
    @GetMapping(path={"/{fileName}"}, produces={"application/json;charset=UTF-8"})
    public TextDto getFile(@PathVariable(value="fileName") String fileName) {
        return new TextDto(this.globalVarRepository.getFile(fileName));
    }

    public static class TextDto {
        private String message;

        public TextDto(@JsonProperty(value="message") String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

