/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.editionlock;

import com.chutneytesting.design.api.editionlock.ImmutableTestCaseEditionDto;
import com.chutneytesting.design.api.editionlock.TestCaseEditionDto;
import com.chutneytesting.design.domain.editionlock.TestCaseEdition;
import com.chutneytesting.design.domain.editionlock.TestCaseEditionsService;
import com.chutneytesting.security.domain.UserService;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v1/editions/testcases"})
public class TestCaseEditionController {
    static final String BASE_URL = "/api/v1/editions/testcases";
    private final TestCaseEditionsService testCaseEditionsService;
    private final UserService userService;

    public TestCaseEditionController(TestCaseEditionsService testCaseEditionsService, UserService userService) {
        this.testCaseEditionsService = testCaseEditionsService;
        this.userService = userService;
    }

    @GetMapping(path={"/{testCaseId}"}, produces={"application/json;charset=UTF-8"})
    public List<TestCaseEditionDto> testCasesEditions(@PathVariable(value="testCaseId") String testCaseId) {
        return this.testCaseEditionsService.getTestCaseEditions(ComposableIdUtils.fromFrontId(testCaseId)).stream().map(TestCaseEditionController::toDto).collect(Collectors.toList());
    }

    @PostMapping(path={"/{testCaseId}"}, produces={"application/json;charset=UTF-8"})
    public TestCaseEditionDto editTestCase(@PathVariable(value="testCaseId") String testCaseId) {
        return TestCaseEditionController.toDto(this.testCaseEditionsService.editTestCase(ComposableIdUtils.fromFrontId(testCaseId), this.userService.getCurrentUser().getId()));
    }

    @DeleteMapping(path={"/{testCaseId}"})
    public void endTestCaseEdition(@PathVariable(value="testCaseId") String testCaseId) {
        this.testCaseEditionsService.endTestCaseEdition(ComposableIdUtils.fromFrontId(testCaseId), this.userService.getCurrentUser().getId());
    }

    private static TestCaseEditionDto toDto(TestCaseEdition tcEdition) {
        return ImmutableTestCaseEditionDto.builder().testCaseId(ComposableIdUtils.toFrontId(tcEdition.testCaseMetadata.id())).testCaseVersion(tcEdition.testCaseMetadata.version()).editionUser(tcEdition.editor).editionStartDate(tcEdition.startDate).build();
    }
}

